/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testminingmodelsummed.miningmodelsum;

import java.util.Collections;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.commons.model.KiePMMLOutputField;

public class MiningModelSum extends KiePMMLMiningModel {

    public MiningModelSum() {
        super("MiningModelSum", Collections.emptyList());
        targetField = "result";
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.REGRESSION;
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.MINING_MODEL;
        segmentation = new testminingmodelsummed.miningmodelsum.miningmodelsumsegmentation.MiningModelSumSegmentation();
        miningFields.add(new org.kie.pmml.api.models.MiningField("input1", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("input2", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("input3", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("result", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.TARGET, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("result", null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, "result", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList()));
        kiePMMLOutputFields.add(KiePMMLOutputField.builder("result", Collections.emptyList()).withRank(1).withTargetField("result").withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).build());
    }
}
