/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testregression.linreg;

import java.util.Collections;
import java.util.Map;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.models.regression.model.KiePMMLRegressionModel;

public class LinReg extends KiePMMLRegressionModel {

    public LinReg() {
        super("LinReg");
        regressionTable = new testregression.linreg.KiePMMLRegressionTableRegression4();
        targetField = "fld4";
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.REGRESSION;
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.REGRESSION_MODEL;
        miningFields.add(new org.kie.pmml.api.models.MiningField("fld1", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("fld2", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("fld3", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, java.util.Arrays.asList("x", "y"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("fld4", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("result", null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, "fld4", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList()));
        kiePMMLOutputFields.add(KiePMMLOutputField.builder("result", Collections.emptyList()).withRank(1).withTargetField("fld4").withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).build());
    }
}
