/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testscorecard.samplescore;

import java.util.Collections;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.models.drools.scorecard.model.KiePMMLScorecardModel;

public class SampleScore extends KiePMMLScorecardModel {

    public SampleScore() {
        super("Sample Score", Collections.emptyList());
        targetField = "overallScore";
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.SCORECARD_MODEL;
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.REGRESSION;
        kiePMMLOutputFields.add(KiePMMLOutputField.builder("calculatedScore", Collections.emptyList()).withRank(1).withTargetField("overallScore").withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).build());
        fieldTypeMap.put("residenceState", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("string", "RESIDENCESTATE"));
        fieldTypeMap.put("validLicense", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("boolean", "VALIDLICENSE"));
        fieldTypeMap.put("occupation", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("string", "OCCUPATION"));
        fieldTypeMap.put("overallScore", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "OVERALLSCORE"));
        fieldTypeMap.put("age", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "AGE"));
        miningFields.add(new org.kie.pmml.api.models.MiningField("age", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("occupation", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, java.util.Arrays.asList("SKYDIVER", "ASTRONAUT", "PROGRAMMER", "TEACHER", "INSTRUCTOR"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("residenceState", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, java.util.Arrays.asList("AP", "KN", "TN"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("validLicense", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.BOOLEAN, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("overallScore", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("calculatedScore", null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, "overallScore", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList()));
        kiePMMLOutputFields.add(KiePMMLOutputField.builder("calculatedScore", Collections.emptyList()).withRank(1).withTargetField("overallScore").withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).build());
    }

    @Override
    public String getKModulePackageName() {
        return "testscorecard.samplescore";
    }
}
