/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmnpmml.kogito.springboot.example;

import io.restassured.RestAssured;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.dmnpmml.kogito.springboot.example.CommonTestUtils;
import org.kie.dmnpmml.kogito.springboot.example.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class ScoreCardTest {
    private static final String BASE_PATH = "/SampleScore";
    private static final String TARGET = "overallScore";
    @LocalServerPort
    private int port;

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    public void testEvaluateScoreCardResult() {
        String inputData = "{\"age\": 23.0, \"occupation\": \"SKYDIVER\", \"residenceState\": \"AP\", \"validLicense\": true}";
        CommonTestUtils.testResult(inputData, BASE_PATH, TARGET, Float.valueOf(21.345f));
    }

    @Test
    public void testEvaluateScoreCardResultWrongData() {
        String inputData = "{\"age\": wrong-data, \"occupation\": \"SKYDIVER\", \"residenceState\": \"AP\", \"validLicense\": true}";
        CommonTestUtils.testResultWrongData(inputData, BASE_PATH);
    }

    @Test
    public void testEvaluateScoreCardResultDescriptive() {
        String inputData = "{\"age\": 23.0, \"occupation\": \"SKYDIVER\", \"residenceState\": \"AP\", \"validLicense\": true}";
        Map<String, Object> expectedResultMap = Collections.singletonMap(TARGET, Float.valueOf(21.345f));
        CommonTestUtils.testDescriptive(inputData, BASE_PATH, TARGET, expectedResultMap);
    }

    @Test
    public void testEvaluateScoreCardResultDescriptiveWrongData() {
        String inputData = "{\"age\": wrong-data, \"occupation\": \"SKYDIVER\", \"residenceState\": \"AP\", \"validLicense\": true}";
        CommonTestUtils.testDescriptiveWrongData(inputData, BASE_PATH);
    }
}

