/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmnpmml.kogito.springboot.example;

import io.restassured.RestAssured;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.dmnpmml.kogito.springboot.example.CommonTestUtils;
import org.kie.dmnpmml.kogito.springboot.example.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class MiningModelTest {
    private static final String BASE_PATH = "/MiningModelSum";
    private static final String TARGET = "result";
    @LocalServerPort
    private int port;

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    void testEvaluateMiningModelResult() {
        String inputData = "{\"input1\":200.0, \"input2\":-1.0, \"input3\":2.0}";
        CommonTestUtils.testResult(inputData, BASE_PATH, TARGET, Float.valueOf(-299.0f));
    }

    @Test
    void testEvaluateMiningModelResultWrongData() {
        String inputData = "{\"input1\":wrong-data, \"input2\":-1.0, \"input3\":2.0}";
        CommonTestUtils.testResultWrongData(inputData, BASE_PATH);
    }

    @Test
    void testEvaluateMiningModelResultDescriptive() {
        String inputData = "{\"input1\":200.0, \"input2\":-1.0, \"input3\":2.0}";
        Map<String, Object> expectedResultMap = Collections.singletonMap(TARGET, Float.valueOf(-299.0f));
        CommonTestUtils.testDescriptive(inputData, BASE_PATH, TARGET, expectedResultMap);
    }

    @Test
    void testEvaluateMiningModelResultDescriptiveWrongData() {
        String inputData = "{\"input1\":wrong-data, \"input2\":-1.0, \"input3\":2.0}";
        CommonTestUtils.testDescriptiveWrongData(inputData, BASE_PATH);
    }
}

