/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quickstart;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.Model;
import org.drools.model.PatternDSL;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.functions.Block1;
import org.drools.model.functions.Predicate1;
import org.drools.model.impl.ModelImpl;
import org.drools.modelcompiler.KiePackagesBuilder;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.KieSession;
import org.kie.kogito.quickstart.Adult;
import org.kie.kogito.quickstart.Person;

@ApplicationScoped
public class AdultCheckService {
    final KieSession ksession;

    AdultCheckService() {
        Declaration pv = DSL.declarationOf(Person.class);
        Rule adult = PatternDSL.rule((String)"adult").build(new RuleItemBuilder[]{PatternDSL.pattern((Variable)pv).expr((Predicate1 & Serializable)p -> p.getAge() > 18), DSL.on((Variable)pv).execute((Block1 & Serializable)p -> this.session().insert((Object)new Adult((Person)p)))});
        ModelImpl model = new ModelImpl().addRule(adult);
        RuleBaseConfiguration kieBaseConf = new RuleBaseConfiguration();
        KiePackagesBuilder builder = new KiePackagesBuilder((KieBaseConfiguration)kieBaseConf);
        builder.addModel((Model)model);
        InternalKnowledgeBase kieBase = new KieBaseBuilder((KieBaseConfiguration)kieBaseConf).createKieBase(builder.build());
        this.ksession = kieBase.newKieSession();
    }

    KieSession session() {
        return this.ksession;
    }

    public void post(Person p) {
        this.ksession.insert((Object)p);
        this.ksession.fireAllRules();
    }

    public List<Person> adults() {
        return this.ksession.getObjects(p -> p instanceof Adult).stream().map(p -> ((Adult)p).getPerson()).collect(Collectors.toList());
    }

    public List<Person> persons() {
        return this.ksession.getObjects(p -> p instanceof Person).stream().map(p -> (Person)p).collect(Collectors.toList());
    }
}

