package org.kie.kogito.rules.alerting;

import java.util.*;
import org.drools.model.*;
import org.drools.modelcompiler.dsl.pattern.D;
import org.drools.model.Index.ConstraintType;
import java.time.*;
import java.time.format.*;
import java.text.*;
import org.drools.core.util.*;
import org.drools.model.Model;

public class Rules4723952D402A230BDB0E7081EBBA10E2 implements Model {

    public final static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.getDateFormatMask());

    @Override
    public String getName() {
        return "org.kie.kogito.rules.alerting";
    }

    public static Date string_2_date(String s) {
        return GregorianCalendar.from(LocalDate.parse(s,
                                                      DATE_TIME_FORMATTER).atStartOfDay(ZoneId.systemDefault()))
                                .getTime();
    }

    /**
     * With the following expression ID:
     * org.drools.modelcompiler.builder.generator.DRLIdGenerator@4b7feb38
     */
    @Override
    public List<org.drools.model.Rule> getRules() {
        return rules;
    }

    @Override
    public List<org.drools.model.EntryPoint> getEntryPoints() {
        return Arrays.asList(D.entryPoint("eventStream"),
                             D.entryPoint("alertStream"));
    }

    @Override
    public List<org.drools.model.Global> getGlobals() {
        return globals;
    }

    @Override
    public List<org.drools.model.Query> getQueries() {
        return queries;
    }

    @Override
    public List<org.drools.model.TypeMetaData> getTypeMetaDatas() {
        return typeMetaDatas;
    }

    public static final org.drools.model.Global<java.util.List> var_log = D.globalOf(java.util.List.class,
                                                                                     "org.kie.kogito.rules.alerting",
                                                                                     "log");

    public static final org.drools.model.Global<org.kie.kogito.rules.DataStream> var_eventStream = D.globalOf(org.kie.kogito.rules.DataStream.class,
                                                                                                              "org.kie.kogito.rules.alerting",
                                                                                                              "eventStream");

    public static final org.drools.model.Global<org.kie.kogito.rules.DataStream> var_alertStream = D.globalOf(org.kie.kogito.rules.DataStream.class,
                                                                                                              "org.kie.kogito.rules.alerting",
                                                                                                              "alertStream");

    List<org.drools.model.Query> queries = Collections.emptyList();

    List<org.drools.model.Global> globals = new ArrayList<>();

    List<org.drools.model.TypeMetaData> typeMetaDatas = Collections.emptyList();

    public static List<Rule> rulesList = Arrays.asList(Rules4723952D402A230BDB0E7081EBBA10E2_rule_org_46kie_46kogito_46rules_46alerting_46MonitoringService_46IncomingEvent.rule_org_46kie_46kogito_46rules_46alerting_46MonitoringService_46IncomingEvent(),
                                                       Rules4723952D402A230BDB0E7081EBBA10E2_rule_org_46kie_46kogito_46rules_46alerting_46LoggerService_46IncomingAlert.rule_org_46kie_46kogito_46rules_46alerting_46LoggerService_46IncomingAlert());

    List<org.drools.model.Rule> rules = rulesList;

    {
        globals.add(var_log);
        globals.add(var_eventStream);
        globals.add(var_alertStream);
    }
}
