package org.kie.kogito.queries;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitInstance;
import static java.util.stream.Collectors.toList;

@Path("/FindAdults")
public class AdultUnitQueryFindAdultsEndpoint {

    @javax.inject.Inject()
    RuleUnit<org.kie.kogito.queries.AdultUnit> ruleUnit;

    public AdultUnitQueryFindAdultsEndpoint() {
    }

    public AdultUnitQueryFindAdultsEndpoint(RuleUnit<org.kie.kogito.queries.AdultUnit> ruleUnit) {
        this.ruleUnit = ruleUnit;
    }

    @POST()
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public List<org.kie.kogito.queries.Person> executeQuery(org.kie.kogito.queries.AdultUnitDTO unitDTO) {
        RuleUnitInstance<org.kie.kogito.queries.AdultUnit> instance = ruleUnit.createInstance(unitDTO.get());
        return instance.executeQuery("FindAdults").stream().map(this::toResult).collect(toList());
    }

    private org.kie.kogito.queries.Person toResult(Map<String, Object> tuple) {
        return (org.kie.kogito.queries.Person) tuple.values().iterator().next();
    }
}
