/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Executor;
import org.kie.kogito.rules.DataObserver;
import org.kie.kogito.rules.DataStream;
import org.kie.kogito.rules.RuleUnitInstance;
import org.kie.kogito.rules.alerting.Event;
import org.kie.kogito.rules.alerting.LoggerService;
import org.kie.kogito.rules.alerting.LoggerServiceRuleUnit;
import org.kie.kogito.rules.alerting.LoggerServiceRuleUnitInstance;
import org.kie.kogito.rules.alerting.MonitoringService;
import org.kie.kogito.rules.alerting.MonitoringServiceRuleUnit;
import org.kie.kogito.rules.alerting.MonitoringServiceRuleUnitInstance;

public class ServicesTest {
    @Test
    public void testExplicitly() {
        MonitoringService monitoringService = new MonitoringService();
        LoggerService loggerService = new LoggerService(monitoringService.getAlertStream());
        monitoringService.getEventStream().append((Object)new Event("Hello!"));
        monitoringService.getEventStream().append((Object)new Event("Hello Again!"));
        monitoringService.getEventStream().append((Object)new Event("Hello 3!"));
        MonitoringServiceRuleUnitInstance monitoringServiceInstance = new MonitoringServiceRuleUnit().createInstance(monitoringService);
        monitoringServiceInstance.fire();
        monitoringService.getEventStream().append((Object)new Event("Hello 4!"));
        monitoringServiceInstance.fire();
        LoggerServiceRuleUnitInstance loggerServiceInstance = new LoggerServiceRuleUnit().createInstance(loggerService);
        loggerServiceInstance.fire();
        CountDownLatch latch = new CountDownLatch(4);
        loggerService.getLogger().subscribe(DataObserver.of(v -> latch.countDown()));
        Assertions.assertEquals((long)0L, (long)latch.getCount());
    }

    @Test
    public void testScheduled() throws InterruptedException {
        MonitoringService monitoringService = new MonitoringService();
        LoggerService loggerService = new LoggerService(monitoringService.getAlertStream());
        CountDownLatch latch = new CountDownLatch(4);
        loggerService.getLogger().subscribe(DataObserver.of(v -> latch.countDown()));
        MonitoringServiceRuleUnitInstance monitoringServiceInstance = new MonitoringServiceRuleUnit().createInstance(monitoringService);
        LoggerServiceRuleUnitInstance loggerServiceInstance = new LoggerServiceRuleUnit().createInstance(loggerService);
        Executor executor = Executor.create();
        executor.submit((RuleUnitInstance)monitoringServiceInstance);
        executor.submit((RuleUnitInstance)loggerServiceInstance);
        DataStream eventStream = monitoringService.getEventStream();
        eventStream.append((Object)new Event("Hello!"));
        eventStream.append((Object)new Event("Hello Again!"));
        eventStream.append((Object)new Event("Hello 3!"));
        eventStream.append((Object)new Event("Hello 4!"));
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((long)0L, (long)latch.getCount(), (String)"countdown must be zero");
    }
}

