/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.drools.project.model.ProjectRuntime;
import org.kie.kogito.Config;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.queries.AdultUnitRuleUnit;
import org.kie.kogito.rules.KieRuntimeBuilder;
import org.kie.kogito.rules.alerting.LoggerServiceRuleUnit;
import org.kie.kogito.rules.alerting.MonitoringServiceRuleUnit;
import org.kie.kogito.uow.UnitOfWorkManager;

@Singleton
public class Application
implements org.kie.kogito.Application {
    @Inject
    Instance<EventPublisher> eventPublishers;
    @Inject
    Config config;
    RuleUnits ruleUnits = new RuleUnits();

    public Config config() {
        return this.config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.config().process().unitOfWorkManager();
    }

    @PostConstruct
    public void setup() {
        if (this.eventPublishers != null) {
            this.eventPublishers.forEach(publisher -> this.unitOfWorkManager().eventManager().addPublisher(publisher));
        }
    }

    public RuleUnits ruleUnits() {
        return this.ruleUnits;
    }

    public class RuleUnits
    implements org.kie.kogito.rules.RuleUnits {
        KieRuntimeBuilder ruleRuntimeBuilder = new ProjectRuntime();

        public KieRuntimeBuilder ruleRuntimeBuilder() {
            return this.ruleRuntimeBuilder;
        }

        public LoggerServiceRuleUnit createLoggerServiceRuleUnit() {
            return new LoggerServiceRuleUnit();
        }

        public MonitoringServiceRuleUnit createMonitoringServiceRuleUnit() {
            return new MonitoringServiceRuleUnit();
        }

        public AdultUnitRuleUnit createAdultUnitRuleUnit() {
            return new AdultUnitRuleUnit();
        }
    }
}

