package org.kie.kogito.rules.alerting;

import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.impl.EnvironmentImpl;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.KieSession;
import org.kie.kogito.Application;
import org.kie.kogito.rules.RuleEventListenerConfig;

@javax.inject.Singleton()
public class MonitoringServiceRuleUnit extends org.kie.kogito.rules.impl.AbstractRuleUnit<MonitoringService> {

    public MonitoringServiceRuleUnit() {
        this(new org.kie.kogito.examples.Application());
    }

    @javax.inject.Inject()
    public MonitoringServiceRuleUnit(org.kie.kogito.Application app) {
        super(app);
    }

    public org.kie.kogito.rules.alerting.MonitoringServiceRuleUnitInstance internalCreateInstance(MonitoringService value) {
        return new org.kie.kogito.rules.alerting.MonitoringServiceRuleUnitInstance(this, value, createLegacySession());
    }

    private KieSession createLegacySession() {
        KieSession ks = app.ruleUnits().ruleRuntimeBuilder().newKieSession(MonitoringService.class);
        ((org.drools.core.impl.StatefulKnowledgeSessionImpl) ks).setApplication(app);
        if (app.config() != null && app.config().rule() != null) {
            RuleEventListenerConfig ruleEventListenerConfig = app.config().rule().ruleEventListeners();
            ruleEventListenerConfig.agendaListeners().forEach(ks::addEventListener);
            ruleEventListenerConfig.ruleRuntimeListeners().forEach(ks::addEventListener);
        }
        return ks;
    }
}
