/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.drools.project.model.ProjectRuntime;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.Config;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.queries.AdultUnitRuleUnit;
import org.kie.kogito.rules.KieRuntimeBuilder;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.alerting.LoggerServiceRuleUnit;
import org.kie.kogito.rules.alerting.MonitoringServiceRuleUnit;
import org.kie.kogito.rules.impl.AbstractRuleUnits;
import org.kie.kogito.uow.UnitOfWorkManager;

@Singleton
public class Application
implements org.kie.kogito.Application {
    @Inject
    Instance<EventPublisher> eventPublishers;
    @ConfigProperty(name="kogito.service.url", defaultValue="")
    String kogitoService;
    @Inject
    Config config;
    RuleUnits ruleUnits = new RuleUnits();

    public Config config() {
        return this.config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.config().process().unitOfWorkManager();
    }

    @PostConstruct
    public void setup() {
        if (this.config().process() != null) {
            if (this.eventPublishers != null) {
                this.eventPublishers.forEach(publisher -> this.unitOfWorkManager().eventManager().addPublisher(publisher));
            }
            this.unitOfWorkManager().eventManager().setService(this.kogitoService);
        }
    }

    public RuleUnits ruleUnits() {
        return this.ruleUnits;
    }

    public class RuleUnits
    extends AbstractRuleUnits {
        KieRuntimeBuilder ruleRuntimeBuilder = new ProjectRuntime();

        public KieRuntimeBuilder ruleRuntimeBuilder() {
            return this.ruleRuntimeBuilder;
        }

        protected RuleUnit<?> create(String fqcn) {
            switch (fqcn) {
                case "org.kie.kogito.rules.alerting.LoggerService": {
                    return new LoggerServiceRuleUnit(Application.this);
                }
                case "org.kie.kogito.rules.alerting.MonitoringService": {
                    return new MonitoringServiceRuleUnit(Application.this);
                }
                case "org.kie.kogito.queries.AdultUnit": {
                    return new AdultUnitRuleUnit(Application.this);
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

