package org.kie.kogito.rules.alerting;

import java.util.*;
import org.drools.model.*;
import org.drools.modelcompiler.dsl.pattern.D;
import org.drools.model.Index.ConstraintType;
import java.time.*;
import java.time.format.*;
import java.text.*;
import org.drools.core.util.*;
import org.drools.model.Model;

public abstract class Rules4723952D402A230BDB0E7081EBBA10E2 implements Model {

    public final static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(DateUtils.getDateFormatMask(),
                                                                                            Locale.ENGLISH);

    @Override
    public String getName() {
        return "org.kie.kogito.rules.alerting";
    }

    public static Date string_2_date(String s) {
        return GregorianCalendar.from(LocalDate.parse(s,
                                                      DATE_TIME_FORMATTER).atStartOfDay(ZoneId.systemDefault()))
                                .getTime();
    }

    @Override
    public List<org.drools.model.EntryPoint> getEntryPoints() {
        return Arrays.asList(D.entryPoint("logger"),
                             D.entryPoint("eventStream"),
                             D.entryPoint("alertStream"));
    }

    @Override
    public List<org.drools.model.Global> getGlobals() {
        return globals;
    }

    @Override
    public List<org.drools.model.TypeMetaData> getTypeMetaDatas() {
        return typeMetaDatas;
    }

    public static final org.drools.model.Global<org.kie.kogito.rules.DataStream> var_logger = D.globalOf(org.kie.kogito.rules.DataStream.class,
                                                                                                         "org.kie.kogito.rules.alerting",
                                                                                                         "logger");

    public static final org.drools.model.Global<org.kie.kogito.rules.DataStream> var_eventStream = D.globalOf(org.kie.kogito.rules.DataStream.class,
                                                                                                              "org.kie.kogito.rules.alerting",
                                                                                                              "eventStream");

    public static final org.drools.model.Global<org.kie.kogito.rules.DataStream> var_alertStream = D.globalOf(org.kie.kogito.rules.DataStream.class,
                                                                                                              "org.kie.kogito.rules.alerting",
                                                                                                              "alertStream");

    List<org.drools.model.Global> globals = new ArrayList<>();

    List<org.drools.model.TypeMetaData> typeMetaDatas = Collections.emptyList();

    {
        globals.add(var_logger);
        globals.add(var_eventStream);
        globals.add(var_alertStream);
    }
}
