/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.queries.AdultUnitDTO;
import org.kie.kogito.queries.AdultUnitQueryFindAdultNamesEndpoint;
import org.kie.kogito.queries.AdultUnitQueryFindAdultsEndpoint;
import org.kie.kogito.queries.AdultUnitQueryFindNotAdultNamesAndAgeEndpoint;
import org.kie.kogito.queries.AdultUnitRuleUnit;
import org.kie.kogito.queries.Person;
import org.kie.kogito.rules.RuleUnit;

public class QueryTest {
    @Test
    public void testPersons() {
        AdultUnitQueryFindAdultsEndpoint query = new AdultUnitQueryFindAdultsEndpoint((RuleUnit)new AdultUnitRuleUnit());
        List results = query.executeQuery(this.createAdultUnitDTO()).stream().map(Person::getName).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertTrue((boolean)results.containsAll(Arrays.asList("Mario", "Marilena")));
    }

    @Test
    public void testNames() {
        AdultUnitQueryFindAdultNamesEndpoint query = new AdultUnitQueryFindAdultNamesEndpoint((RuleUnit)new AdultUnitRuleUnit());
        List results = query.executeQuery(this.createAdultUnitDTO());
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertTrue((boolean)results.containsAll(Arrays.asList("Mario", "Marilena")));
    }

    @Test
    public void testResult() {
        AdultUnitQueryFindNotAdultNamesAndAgeEndpoint query = new AdultUnitQueryFindNotAdultNamesAndAgeEndpoint((RuleUnit)new AdultUnitRuleUnit());
        List results = query.executeQuery(this.createAdultUnitDTO());
        Assertions.assertEquals((int)1, (int)results.size());
        AdultUnitQueryFindNotAdultNamesAndAgeEndpoint.Result result = (AdultUnitQueryFindNotAdultNamesAndAgeEndpoint.Result)results.get(0);
        Assertions.assertEquals((Object)"Sofia", (Object)result.get$name());
        Assertions.assertEquals((int)7, (int)result.get$age());
    }

    private AdultUnitDTO createAdultUnitDTO() {
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(new Person("Mario", 45));
        persons.add(new Person("Marilena", 47));
        persons.add(new Person("Sofia", 7));
        AdultUnitDTO adultsDTO = new AdultUnitDTO();
        adultsDTO.setAdultAge(18);
        adultsDTO.setPersons(persons);
        return adultsDTO;
    }
}

