package org.kie.kogito.rules.alerting;

import org.kie.api.runtime.KieSession;
import org.kie.kogito.rules.RuleEventListenerConfig;
import org.kie.kogito.rules.units.impl.AbstractRuleUnit;

@javax.inject.Singleton()
public class LoggerServiceRuleUnit extends AbstractRuleUnit<LoggerService> {

    public LoggerServiceRuleUnit() {
        this(new org.kie.kogito.examples.Application());
    }

    @javax.inject.Inject()
    public LoggerServiceRuleUnit(org.kie.kogito.Application app) {
        super(app);
    }

    public org.kie.kogito.rules.alerting.LoggerServiceRuleUnitInstance internalCreateInstance(LoggerService value) {
        return new org.kie.kogito.rules.alerting.LoggerServiceRuleUnitInstance(this, value, createLegacySession());
    }

    private KieSession createLegacySession() {
        KieSession ks = app.ruleUnits().ruleRuntimeBuilder().newKieSession(LoggerService.class);
        ((org.drools.core.impl.StatefulKnowledgeSessionImpl) ks).setApplication(app);
        if (app.config() != null && app.config().rule() != null) {
            RuleEventListenerConfig ruleEventListenerConfig = app.config().rule().ruleEventListeners();
            ruleEventListenerConfig.agendaListeners().forEach(ks::addEventListener);
            ruleEventListenerConfig.ruleRuntimeListeners().forEach(ks::addEventListener);
        }
        return ks;
    }
}
