/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.flexible.example.quarkus;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.flexible.example.model.Product;
import org.kie.kogito.flexible.example.model.State;
import org.kie.kogito.flexible.example.model.SupportCase;
import org.kie.kogito.flexible.example.service.TriageService;

@QuarkusTest
class ServiceDeskProcessTest {
    private static final String BASE_PATH = "/serviceDesk";

    ServiceDeskProcessTest() {
    }

    @Test
    void testSupportCaseExample() {
        String id = this.createSupportCase();
        this.addSupportComment(id);
        this.addCustomerComment(id);
        this.resolveCase(id);
        this.sendQuestionnaire(id);
        this.checkAllProcessesFinished();
    }

    private String createSupportCase() {
        SupportCase supportCase = new SupportCase().setProduct(new Product().setFamily("Middleware").setName("Kogito")).setCustomer("Paco").setDescription("Something is not working");
        HashMap<String, SupportCase> params = new HashMap<String, SupportCase>();
        params.put("supportCase", supportCase);
        String id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(params).post(BASE_PATH, new Object[0])).then()).statusCode(201)).header("Location", CoreMatchers.notNullValue())).body("id", CoreMatchers.notNullValue(), new Object[0])).body("supportCase.state", CoreMatchers.is((Object)State.WAITING_FOR_OWNER.name()), new Object[0])).body("supportCase.engineer", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)TriageService.KOGITO_ENGINEERS[0]), CoreMatchers.is((Object)TriageService.KOGITO_ENGINEERS[1])}), new Object[0])).body("supportGroup", CoreMatchers.is((Object)"Kogito"), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).basePath(BASE_PATH).when().get(id, new Object[0])).then()).statusCode(200);
        return id;
    }

    private void addSupportComment(String id) {
        String location = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath(BASE_PATH).contentType(ContentType.JSON).when().post("/{id}/ReceiveSupportComment", new Object[]{id})).then()).statusCode(201)).header("Location", CoreMatchers.notNullValue())).extract().header("Location");
        String taskId = location.substring(location.lastIndexOf("/") + 1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("comment", "Have you tried to turn it off and on again?");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath(BASE_PATH).queryParam("user", new Object[]{"kelly"}).queryParam("group", new Object[]{"support"}).contentType(ContentType.JSON).when().body(params).post("/{id}/ReceiveSupportComment/{taskId}", new Object[]{id, taskId})).then()).statusCode(200)).body("supportCase.state", CoreMatchers.is((Object)State.WAITING_FOR_CUSTOMER.name()), new Object[0])).body("supportCase.comments[0].text", CoreMatchers.is(params.get("comment")), new Object[0])).body("supportCase.comments[0].author", CoreMatchers.is((Object)"kelly"), new Object[0])).body("supportCase.comments[0].date", CoreMatchers.notNullValue(), new Object[0]);
    }

    private void addCustomerComment(String id) {
        String location = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/serviceDesk/" + id).contentType(ContentType.JSON).when().post("/ReceiveCustomerComment", new Object[0])).then()).statusCode(201)).header("Location", CoreMatchers.notNullValue())).extract().header("Location");
        String taskId = location.substring(location.lastIndexOf("/") + 1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("comment", "Great idea!");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath(BASE_PATH).queryParam("user", new Object[]{"Paco"}).queryParam("group", new Object[]{"customer"}).contentType(ContentType.JSON).when().body(params).post("/{id}/ReceiveCustomerComment/{taskId}", new Object[]{id, taskId})).then()).statusCode(200)).body("supportCase.state", CoreMatchers.is((Object)State.WAITING_FOR_OWNER.name()), new Object[0])).body("supportCase.comments[1].text", CoreMatchers.is(params.get("comment")), new Object[0])).body("supportCase.comments[1].author", CoreMatchers.is((Object)"Paco"), new Object[0])).body("supportCase.comments[1].date", CoreMatchers.notNullValue(), new Object[0]);
    }

    private void resolveCase(String id) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/serviceDesk/" + id).contentType(ContentType.JSON).when().post("/Resolve_Case", new Object[0])).then()).statusCode(200)).body("supportCase.state", CoreMatchers.is((Object)State.RESOLVED.name()), new Object[0]);
    }

    private void sendQuestionnaire(String id) {
        String taskId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/serviceDesk/" + id).contentType(ContentType.JSON).when().get("/tasks", new Object[0])).then()).statusCode(200)).body("$.size", CoreMatchers.is((Object)1), new Object[0])).body("[0].name", CoreMatchers.is((Object)"Questionnaire"), new Object[0])).extract().path("[0].id", new String[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("comment", "Kogito is great!");
        params.put("evaluation", 10);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/serviceDesk/" + id).queryParam("user", new Object[]{"Paco"}).queryParam("group", new Object[]{"customer"}).contentType(ContentType.JSON).when().body(params).post("/Questionnaire/" + taskId, new Object[0])).then()).statusCode(200)).body("supportCase.state", CoreMatchers.is((Object)State.CLOSED.name()), new Object[0])).body("supportCase.questionnaire.comment", CoreMatchers.is(params.get("comment")), new Object[0])).body("supportCase.questionnaire.evaluation", CoreMatchers.is(params.get("evaluation")), new Object[0])).body("supportCase.questionnaire.date", CoreMatchers.notNullValue(), new Object[0]);
    }

    private void checkAllProcessesFinished() {
        List processes = (List)((Response)RestAssured.given().basePath(BASE_PATH).contentType(ContentType.JSON).when().get("/", new Object[0])).as(List.class);
        Assertions.assertTrue((boolean)processes.isEmpty());
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }
}

