package org.kie.kogito.examples;

import org.kie.kogito.Config;
import org.kie.kogito.process.Processes;
import org.kie.kogito.uow.UnitOfWorkManager;

@javax.inject.Singleton()
public class Application implements org.kie.kogito.Application {

    @javax.inject.Inject()
    javax.enterprise.inject.Instance<org.kie.kogito.event.EventPublisher> eventPublishers;

    @javax.inject.Inject()
    org.kie.kogito.Config config;

    Processes processes = new Processes();

    public Config config() {
        return config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return config().process().unitOfWorkManager();
    }

    @javax.annotation.PostConstruct()
    public void setup() {
        if (eventPublishers != null) {
            eventPublishers.forEach(publisher -> unitOfWorkManager().eventManager().addPublisher(publisher));
        }
    }

    public Processes processes() {
        return processes;
    }

    public class Processes implements org.kie.kogito.process.Processes {

        public org.kie.kogito.process.Process<? extends org.kie.kogito.Model> processById(String processId) {
            if ("applicantprocess".equals(processId))
                return createApplicantprocessProcess();
            return null;
        }

        public java.util.Collection<String> processIds() {
            return java.util.Arrays.asList("applicantprocess");
        }

        public org.kogito.examples.polyglot.ApplicantprocessProcess createApplicantprocessProcess() {
            return new org.kogito.examples.polyglot.ApplicantprocessProcess(Application.this).configure();
        }
    }
}
