/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Config;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.kie.kogito.rules.RuleConfig;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;

@Singleton
public class ApplicationConfig
implements Config {
    protected ProcessConfig processConfig;
    protected RuleConfig ruleConfig;
    private ProcessEventListenerConfig defaultProcessEventListenerConfig = new DefaultProcessEventListenerConfig(new ProcessEventListener[0]);
    private WorkItemHandlerConfig defaultWorkItemHandlerConfig = new DefaultWorkItemHandlerConfig();
    private UnitOfWorkManager defaultUnitOfWorkManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
    @Inject
    Instance<ProcessEventListenerConfig> processEventListenerConfig;
    @Inject
    Instance<WorkItemHandlerConfig> workItemHandlerConfig;
    @Inject
    Instance<UnitOfWorkManager> unitOfWorkManager;

    public ProcessConfig process() {
        return this.processConfig;
    }

    public RuleConfig rule() {
        return this.ruleConfig;
    }

    protected WorkItemHandlerConfig extract_workItemHandlerConfig() {
        if (!this.workItemHandlerConfig.isUnsatisfied()) {
            return (WorkItemHandlerConfig)this.workItemHandlerConfig.get();
        }
        return this.defaultWorkItemHandlerConfig;
    }

    protected ProcessEventListenerConfig extract_processEventListenerConfig() {
        if (!this.processEventListenerConfig.isUnsatisfied()) {
            return (ProcessEventListenerConfig)this.processEventListenerConfig.get();
        }
        return this.defaultProcessEventListenerConfig;
    }

    protected UnitOfWorkManager extract_unitOfWorkManager() {
        if (!this.unitOfWorkManager.isUnsatisfied()) {
            return (UnitOfWorkManager)this.unitOfWorkManager.get();
        }
        return this.defaultUnitOfWorkManager;
    }

    @PostConstruct
    public void init() {
        this.processConfig = new StaticProcessConfig(this.extract_workItemHandlerConfig(), this.extract_processEventListenerConfig(), this.extract_unitOfWorkManager());
        this.ruleConfig = null;
    }
}

