package org.kie.kogito.examples;

import org.kie.kogito.Config;
import org.kie.kogito.process.Processes;
import org.kie.kogito.uow.UnitOfWorkManager;

@javax.inject.Singleton()
public class Application implements org.kie.kogito.Application {

    @javax.inject.Inject()
    javax.enterprise.inject.Instance<org.kie.kogito.event.EventPublisher> eventPublishers;

    @org.eclipse.microprofile.config.inject.ConfigProperty(name = "kogito.service.url", defaultValue = "")
    java.lang.String kogitoService;

    @javax.inject.Inject()
    org.kie.kogito.Config config;

    Processes processes = new Processes();

    public Config config() {
        return config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return config().process().unitOfWorkManager();
    }

    @javax.annotation.PostConstruct()
    public void setup() {
        if (config().process() != null) {
            if (eventPublishers != null) {
                eventPublishers.forEach(publisher -> unitOfWorkManager().eventManager().addPublisher(publisher));
            }
            unitOfWorkManager().eventManager().setService(kogitoService);
        }
    }

    public Processes processes() {
        return processes;
    }

    public class Processes implements org.kie.kogito.process.Processes {

        public org.kie.kogito.process.Process<? extends org.kie.kogito.Model> processById(String processId) {
            if ("applicantprocess".equals(processId))
                return new org.kogito.examples.polyglot.ApplicantprocessProcess(Application.this).configure();
            return null;
        }

        public java.util.Collection<String> processIds() {
            return java.util.Arrays.asList("applicantprocess");
        }
    }
}
