/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.polyglot;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Collections;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.examples.polyglot.Applicant;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;

@QuarkusTest
public class ApplicantProcessTest {
    @Inject
    Application kogitoApp;

    @Test
    public void testInvalidApplicant() {
        Applicant applicant = new Applicant();
        applicant.setFname("test");
        applicant.setLname("user");
        applicant.setAge(13);
        applicant.setValid(true);
        this.getApplicantProcessInstance(applicant).start();
        Assertions.assertFalse((boolean)applicant.isValid());
    }

    @Test
    public void testValidApplicant() {
        Applicant applicant = new Applicant();
        applicant.setFname("test");
        applicant.setLname("user");
        applicant.setAge(22);
        applicant.setValid(false);
        this.getApplicantProcessInstance(applicant).start();
        Assertions.assertTrue((boolean)applicant.isValid());
    }

    private ProcessInstance<?> getApplicantProcessInstance(Applicant applicant) {
        Process p = this.kogitoApp.processes().processById("applicantprocess");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("applicant", applicant));
        ProcessInstance processInstance = p.createInstance(m);
        return processInstance;
    }
}

