/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.Config;
import org.kie.kogito.Model;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.process.Process;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kogito.examples.polyglot.ApplicantprocessProcess;

@Singleton
public class Application
implements org.kie.kogito.Application {
    @Inject
    Instance<EventPublisher> eventPublishers;
    @ConfigProperty(name="kogito.service.url", defaultValue="")
    String kogitoService;
    @Inject
    Config config;
    Processes processes = new Processes();

    public Config config() {
        return this.config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.config().process().unitOfWorkManager();
    }

    @PostConstruct
    public void setup() {
        if (this.config().process() != null) {
            if (this.eventPublishers != null) {
                this.eventPublishers.forEach(publisher -> this.unitOfWorkManager().eventManager().addPublisher(publisher));
            }
            this.unitOfWorkManager().eventManager().setService(this.kogitoService);
            this.unitOfWorkManager().eventManager().setAddons(this.config().addons());
        }
    }

    public Processes processes() {
        return this.processes;
    }

    public class Processes
    implements org.kie.kogito.process.Processes {
        public Process<? extends Model> processById(String processId) {
            if ("applicantprocess".equals(processId)) {
                return new ApplicantprocessProcess(Application.this).configure();
            }
            return null;
        }

        public Collection<String> processIds() {
            return Arrays.asList("applicantprocess");
        }
    }
}

