/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.examples.polyglot;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.kie.kogito.Application;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kogito.examples.polyglot.ApplicantprocessModel;
import org.kogito.examples.polyglot.ApplicantprocessModelInput;
import org.kogito.examples.polyglot.ApplicantprocessModelOutput;

@Path(value="/applicantprocess")
@ApplicationScoped
public class ApplicantprocessResource {
    @Inject
    @Named(value="applicantprocess")
    Process<ApplicantprocessModel> process;
    @Inject
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ApplicantprocessModelOutput createResource_applicantprocess(@Context HttpHeaders httpHeaders, @QueryParam(value="businessKey") String businessKey, @Valid @NotNull ApplicantprocessModelInput resource) {
        if (resource == null) {
            resource = new ApplicantprocessModelInput();
        }
        ApplicantprocessModelInput value = resource;
        return (ApplicantprocessModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)this.mapInput(value, new ApplicantprocessModel()));
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            return this.getModel((ProcessInstance<ApplicantprocessModel>)pi);
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<ApplicantprocessModelOutput> getResources_applicantprocess() {
        return this.process.instances().values().stream().map(pi -> this.mapOutput(new ApplicantprocessModelOutput(), (ApplicantprocessModel)pi.variables())).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public ApplicantprocessModelOutput getResource_applicantprocess(@PathParam(value="id") String id) {
        return this.process.instances().findById(id).map(pi -> this.mapOutput(new ApplicantprocessModelOutput(), (ApplicantprocessModel)pi.variables())).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public ApplicantprocessModelOutput deleteResource_applicantprocess(@PathParam(value="id") String id) {
        return (ApplicantprocessModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.abort();
            return this.getModel((ProcessInstance<ApplicantprocessModel>)pi);
        });
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ApplicantprocessModelOutput updateModel_applicantprocess(@PathParam(value="id") String id, ApplicantprocessModel resource) {
        return (ApplicantprocessModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.updateVariables((Object)resource);
            return this.mapOutput(new ApplicantprocessModelOutput(), (ApplicantprocessModel)pi.variables());
        });
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<String, String> getTasks_applicantprocess(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> pi.workItems(this.policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected ApplicantprocessModelOutput getModel(ProcessInstance<ApplicantprocessModel> pi) {
        if (pi.status() == 5 && pi.error().isPresent()) {
            throw new ProcessInstanceExecutionException(pi.id(), ((ProcessError)pi.error().get()).failedNodeId(), ((ProcessError)pi.error().get()).errorMessage());
        }
        return this.mapOutput(new ApplicantprocessModelOutput(), (ApplicantprocessModel)pi.variables());
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        StaticIdentityProvider identity = null;
        if (user != null) {
            identity = new StaticIdentityProvider(user, groups);
        }
        return new Policy[]{SecurityPolicy.of((IdentityProvider)identity)};
    }

    protected ApplicantprocessModel mapInput(@Valid @NotNull ApplicantprocessModelInput input, ApplicantprocessModel resource) {
        resource.fromMap(input.toMap());
        return resource;
    }

    protected ApplicantprocessModelOutput mapOutput(ApplicantprocessModelOutput output, ApplicantprocessModel resource) {
        output.fromMap(resource.getId(), resource.toMap());
        return output;
    }
}

