/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.Config;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.examples.Processes;
import org.kie.kogito.uow.UnitOfWorkManager;

@Singleton
public class Application
implements org.kie.kogito.Application {
    @Inject
    Instance<EventPublisher> eventPublishers;
    @ConfigProperty(name="kogito.service.url")
    Optional<String> kogitoService;
    @Inject
    Config config;
    Processes processes = new Processes(this);

    public Config config() {
        return this.config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.config().process().unitOfWorkManager();
    }

    @PostConstruct
    public void setup() {
        if (this.config().process() != null) {
            if (this.eventPublishers != null) {
                this.eventPublishers.forEach(publisher -> this.unitOfWorkManager().eventManager().addPublisher(publisher));
            }
            this.unitOfWorkManager().eventManager().setService(this.kogitoService.orElse(""));
            this.unitOfWorkManager().eventManager().setAddons(this.config().addons());
        }
    }

    public Processes processes() {
        return this.processes;
    }
}

