/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.examples.demo.Order;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.WorkItem;

@QuarkusTest
public class OrdersProcessTest {
    @Inject
    @Named(value="demo.orders")
    Process<? extends Model> orderProcess;
    @Inject
    @Named(value="demo.orderItems")
    Process<? extends Model> orderItemsProcess;

    @Test
    public void testOrderProcess() {
        Assertions.assertNotNull(this.orderProcess);
        Model m = (Model)this.orderProcess.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        parameters.put("order", (String)new Order("12345", Boolean.valueOf(false), Double.valueOf(0.0)));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.orderProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
        Assertions.assertTrue((((Order)result.toMap().get("order")).getTotal() > 0.0 ? 1 : 0) != 0);
        ProcessInstances orderItemProcesses = this.orderItemsProcess.instances();
        Assertions.assertEquals((int)1, (int)orderItemProcesses.values().size());
        ProcessInstance childProcessInstance = (ProcessInstance)orderItemProcesses.values().iterator().next();
        List workItems = childProcessInstance.workItems();
        Assertions.assertEquals((int)1, (int)workItems.size());
        childProcessInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId().longValue(), null);
        Assertions.assertEquals((int)2, (int)childProcessInstance.status());
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Assertions.assertEquals((int)0, (int)this.orderProcess.instances().values().size());
        Assertions.assertEquals((int)0, (int)this.orderItemsProcess.instances().values().size());
    }
}

