/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;

@QuarkusTest
public class PersonsRestTest {
    @Inject
    @Named(value="persons")
    Process<? extends Model> personProcess;

    @BeforeEach
    public void setup() {
        this.personProcess.instances().values().forEach(pi -> pi.abort());
    }

    @Test
    public void testAdultPersonsRest() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"John Doe\", \"age\" : 20}}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRest() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next(), new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRestWithSecurityPolicy() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRestWithSecurityPolicyNotAuthorized() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=john", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)0, (int)taskInfo.size());
        taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=john", new Object[0])).then()).statusCode(403);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskInfo.keySet().iterator().next() + "?user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testChildPersonsRestWithSecurityPolicyAndLifeCycles() {
        Assertions.assertNotNull(this.personProcess);
        String addPersonPayload = "{\"person\" : {\"name\" : \"Jane Doe\", \"age\" : 16}}";
        String firstCreatedId = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(addPersonPayload).when().post("/persons", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)1), new Object[]{"[0].id", CoreMatchers.is((Object)firstCreatedId)});
        Map taskInfo = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons/" + firstCreatedId + "/tasks?user=admin", new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)taskInfo.size());
        taskInfo.containsValue("ChildrenHandling");
        String taskId = (String)taskInfo.keySet().iterator().next();
        String fixedOrderPayload = "{}";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskId + "?phase=claim&user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskId + "?phase=release&user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body(fixedOrderPayload).when().post("/persons/" + firstCreatedId + "/ChildrenHandling/" + taskId + "?phase=skip&user=admin", new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.is((Object)firstCreatedId), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/persons", new Object[0])).then()).statusCode(200)).body("$.size()", CoreMatchers.is((Object)0), new Object[0]);
    }
}

