/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.addons.k8s.Endpoint;
import org.kie.kogito.addons.k8s.EndpointDiscovery;
import org.kie.kogito.addons.k8s.EndpointQueryKey;
import org.kie.kogito.addons.k8s.LocalEndpointDiscovery;
import org.kie.kogito.addons.quarkus.k8s.workitems.QuarkusDiscoveredEndpointCaller;
import org.kie.kogito.examples.onboarding.DecisionTaskWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig;

public abstract class BaseWorkItemHandlerConfig
extends DefaultWorkItemHandlerConfig {
    @Inject
    QuarkusDiscoveredEndpointCaller endpointCaller;
    @ConfigProperty(name="org.acme.kogito.onboarding.local", defaultValue="false")
    Boolean isLocalRunning;
    private final Map<String, KogitoWorkItemHandler> workItemHandlers = new HashMap<String, KogitoWorkItemHandler>();
    protected final List<String> supportedHandlers = Arrays.asList("AssignDepartmentAndManager", "CalculatePaymentDate", "CalculateVacationDays", "CalculateTaxRate", "ValidateEmployee", "AssignIdAndEmail", "DecisionTask");

    public KogitoWorkItemHandler forName(String name) {
        this.workItemHandlers.putIfAbsent("DecisionTask", new DecisionTaskWorkItemHandler(this.endpointCaller));
        if (this.supportedHandlers.contains(name)) {
            return this.workItemHandlers.get("DecisionTask");
        }
        return super.forName(name);
    }

    public Collection<String> names() {
        ArrayList<String> names = new ArrayList<String>(this.supportedHandlers);
        names.addAll(super.names());
        return names;
    }

    @PostConstruct
    public void loadLocalServicesIfNotOnKube() {
        if (this.isLocalRunning.booleanValue()) {
            LocalEndpointDiscovery endpointDiscovery = new LocalEndpointDiscovery();
            String namespace = System.getenv("NAMESPACE");
            endpointDiscovery.addCache(new EndpointQueryKey(namespace, "id"), new Endpoint("http://localhost:8081/id"));
            endpointDiscovery.addCache(new EndpointQueryKey(namespace, "department"), new Endpoint("http://localhost:8081/department/first"));
            endpointDiscovery.addCache(new EndpointQueryKey(namespace, "employeeValidation"), new Endpoint("http://localhost:8081/employee-validation/first"));
            endpointDiscovery.addCache(new EndpointQueryKey(namespace, "vacations/days"), new Endpoint("http://localhost:8082/vacations/days"));
            endpointDiscovery.addCache(new EndpointQueryKey(namespace, "taxes/rate"), new Endpoint("http://localhost:8082/taxes/rate"));
            endpointDiscovery.addCache(new EndpointQueryKey(namespace, "payments/date"), new Endpoint("http://localhost:8082/payments/date"));
            this.endpointCaller.setEndpointDiscovery((EndpointDiscovery)endpointDiscovery);
        }
    }
}

