/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.onboarding;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.examples.onboarding.OnboardingModel;
import org.kie.kogito.examples.onboarding.Onboarding_3_TaskInput;
import org.kie.kogito.examples.onboarding.Onboarding_3_TaskOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;

@Path(value="/onboarding")
@Api(description="onboarding")
public class OnboardingResource {
    @Inject
    @Named(value="onboarding.onboarding")
    Process<OnboardingModel> process;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates new instance of onboarding")
    public OnboardingModel createResource_onboarding(@ApiParam(value="onboarding data that should be created") OnboardingModel resource) {
        if (resource == null) {
            resource = new OnboardingModel();
        }
        ProcessInstance pi = this.process.createInstance((Object)resource);
        pi.start();
        return (OnboardingModel)pi.variables();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns a list of onboarding")
    public List<OnboardingModel> getResources_onboarding() {
        return this.process.instances().values().stream().map(ProcessInstance::variables).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns information about specified onboarding")
    public OnboardingModel getResource_onboarding(@PathParam(value="id") Long id) {
        return this.process.instances().findById(id.longValue()).map(ProcessInstance::variables).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Cancels specified onboarding")
    public OnboardingModel deleteResource_onboarding(@PathParam(value="id") Long id) {
        ProcessInstance pi = this.process.instances().findById(id.longValue()).orElse(null);
        if (pi == null) {
            return null;
        }
        pi.abort();
        return (OnboardingModel)pi.variables();
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns list of task ids that are currently active in given onboarding")
    public Map<Long, String> getTasks_onboarding(@PathParam(value="id") Long id) {
        return this.process.instances().findById(id.longValue()).map(ProcessInstance::workItems).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    @POST
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Completes ManagerConfirmation task")
    public OnboardingModel completeTask_3(@PathParam(value="id") Long id, @PathParam(value="workItemId") Long workItemId, @ApiParam(value="Data for ManagerConfirmation task") Onboarding_3_TaskOutput model) {
        try {
            ProcessInstance pi = this.process.instances().findById(id.longValue()).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.completeWorkItem(workItemId.longValue(), model.toMap());
            return (OnboardingModel)pi.variables();
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns ManagerConfirmation task with data")
    public Onboarding_3_TaskInput getTask_3(@PathParam(value="id") Long id, @PathParam(value="workItemId") Long workItemId) {
        try {
            ProcessInstance pi = this.process.instances().findById(id.longValue()).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId);
            if (workItem == null) {
                return null;
            }
            return Onboarding_3_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Aborts ManagerConfirmation task")
    public OnboardingModel abortTask_3(@PathParam(value="id") Long id, @PathParam(value="workItemId") Long workItemId) {
        try {
            ProcessInstance pi = this.process.instances().findById(id.longValue()).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.abortWorkItem(workItemId.longValue());
            return (OnboardingModel)pi.variables();
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}

