package org.kie.kogito.examples.onboarding;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.examples.onboarding.OnboardingModel;

@Path("/onboarding")
public class OnboardingResource {

    @javax.inject.Inject()
    @javax.inject.Named("onboarding.onboarding")
    Process<OnboardingModel> process;

    @POST()
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public OnboardingModel createResource_onboarding(OnboardingModel resource) {
        if (resource == null) {
            resource = new OnboardingModel();
        }
        ProcessInstance<OnboardingModel> pi = process.createInstance(resource);
        pi.start();
        return pi.variables();
    }

    @GET()
    @Produces(MediaType.APPLICATION_JSON)
    public List<OnboardingModel> getResources_onboarding() {
        return process.instances().values().stream().map(ProcessInstance::variables).collect(Collectors.toList());
    }

    @GET()
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public OnboardingModel getResource_onboarding(@PathParam("id") Long id) {
        return process.instances().findById(id).map(ProcessInstance::variables).orElse(null);
    }

    @DELETE()
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public OnboardingModel deleteResource_onboarding(@PathParam("id") Long id) {
        ProcessInstance<OnboardingModel> pi = process.instances().findById(id).orElse(null);
        if (pi == null) {
            return null;
        } else {
            pi.abort();
            return pi.variables();
        }
    }

    @GET()
    @Path("/{id}/tasks")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<Long, String> getTasks_onboarding(@PathParam("id") Long id) {
        return process.instances().findById(id).map(ProcessInstance::workItems).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    @POST()
    @Path("/{id}/ManagerConfirmation/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public OnboardingModel completeTask_3(@PathParam("id") Long id, @PathParam("workItemId") Long workItemId, Onboarding_3_TaskOutput model) {
        try {
            ProcessInstance<OnboardingModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                pi.completeWorkItem(workItemId, model.toMap());
                return pi.variables();
            }
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("/{id}/ManagerConfirmation/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public Onboarding_3_TaskInput getTask_3(@PathParam("id") Long id, @PathParam("workItemId") Long workItemId) {
        try {
            ProcessInstance<OnboardingModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                WorkItem workItem = pi.workItem(workItemId);
                if (workItem == null) {
                    return null;
                }
                return Onboarding_3_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
            }
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE()
    @Path("/{id}/ManagerConfirmation/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public OnboardingModel abortTask_3(@PathParam("id") Long id, @PathParam("workItemId") Long workItemId) {
        try {
            ProcessInstance<OnboardingModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                pi.abortWorkItem(workItemId);
                return pi.variables();
            }
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}
