/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.onboarding;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.Application;
import org.kie.kogito.examples.test.RecordedOutputWorkItemHandler;

@QuarkusTest
public class OnboardingEndpointTest {
    @Inject
    Application application;

    @Test
    public void testOnboardingProcessUserAlreadyExists() {
        this.registerHandler("ValidateEmployee", workitem -> {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("status", "exists");
            results.put("message", "user already exists");
            return results;
        });
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"employee\" : {\"firstName\" : \"Mark\", \"lastName\" : \"Test\", \"personalId\" : \"xxx-yy-zzz\", \"birthDate\" : \"1995-12-10T14:50:12.123+02:00\", \"address\" : {\"country\" : \"US\", \"city\" : \"Boston\", \"street\" : \"any street 3\", \"zipCode\" : \"10001\"}}}").contentType(ContentType.JSON).when().post("/onboarding", new Object[0])).then()).statusCode(200)).body("status", Is.is((Object)"exists"), new Object[0])).body("message", Is.is((Object)"user already exists"), new Object[0]);
    }

    @Test
    public void testOnboardingProcessNewUserUS() {
        this.registerHandler("ValidateEmployee", workitem -> {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("status", "new");
            results.put("message", "user needs to be onboarded");
            return results;
        });
        this.registerHandler("AssignIdAndEmail", workitem -> {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("email", "test@company.com");
            results.put("employeeId", "acb123");
            return results;
        });
        this.registerHandler("AssignDepartmentAndManager", workitem -> {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("manager", "mary frog");
            results.put("department", "US00099");
            return results;
        });
        this.registerHandler("CalculatePaymentDate", workitem -> {
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("paymentDate", "2019-05-01T23:59:00.123Z[UTC]");
            return results;
        });
        this.registerHandler("CalculateVacationDays", workitem -> {
            HashMap<String, Integer> results = new HashMap<String, Integer>();
            results.put("vacationDays", 25);
            return results;
        });
        this.registerHandler("CalculateTaxRate", workitem -> {
            HashMap<String, Double> results = new HashMap<String, Double>();
            results.put("taxRate", 22.0);
            return results;
        });
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body("{\"employee\" : {\"firstName\" : \"Mark\", \"lastName\" : \"Test\", \"personalId\" : \"xxx-yy-zzz\", \"birthDate\" : \"1995-12-10T14:50:12.123+02:00\", \"address\" : {\"country\" : \"US\", \"city\" : \"Boston\", \"street\" : \"any street 3\", \"zipCode\" : \"10001\"}}}").contentType(ContentType.JSON).when().post("/onboarding", new Object[0])).then()).statusCode(200)).body("status", Is.is((Object)"new"), new Object[0])).body("message", Is.is((Object)"user needs to be onboarded"), new Object[0])).body("email", Is.is((Object)"test@company.com"), new Object[0])).body("employeeId", Is.is((Object)"acb123"), new Object[0])).body("manager", Is.is((Object)"mary frog"), new Object[0])).body("department", Is.is((Object)"US00099"), new Object[0])).body("payroll.paymentDate", Is.is((Object)"2019-05-01T23:59:00.123Z[UTC]"), new Object[0])).body("payroll.vacationDays", Is.is((Object)25), new Object[0])).body("payroll.taxRate", Is.is((Object)new Float(22.0)), new Object[0]);
    }

    protected void registerHandler(String name, Function<WorkItem, Map<String, Object>> item) {
        WorkItemHandler handler = this.application.config().process().workItemHandlers().forName(name);
        ((RecordedOutputWorkItemHandler)handler).record(name, item);
    }
}

