/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.Arrays;
import java.util.Collection;
import javax.inject.Singleton;
import org.kie.kogito.Config;
import org.kie.kogito.Model;
import org.kie.kogito.StaticConfig;
import org.kie.kogito.examples.ProcessEventListenerConfig;
import org.kie.kogito.examples.WorkItemHandlerConfig;
import org.kie.kogito.examples.onboarding.OnboardingProcess;
import org.kie.kogito.examples.onboarding.SetupHRProcess;
import org.kie.kogito.examples.onboarding.SetupPayrollProcess;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;

@Singleton
public class Application
implements org.kie.kogito.Application {
    private static UnitOfWorkManager unitOfWorkManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
    public static Config config = new StaticConfig((ProcessConfig)new StaticProcessConfig((org.kie.kogito.process.WorkItemHandlerConfig)new WorkItemHandlerConfig(), (org.kie.kogito.process.ProcessEventListenerConfig)new ProcessEventListenerConfig(), unitOfWorkManager), null);
    Processes processes = new Processes();

    public Config config() {
        return config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return unitOfWorkManager;
    }

    public Processes processes() {
        return this.processes;
    }

    public class Processes
    implements org.kie.kogito.process.Processes {
        public Process<? extends Model> processById(String processId) {
            if ("onboarding.onboarding".equals(processId)) {
                return this.createOnboardingProcess();
            }
            if ("onboarding.setupHR".equals(processId)) {
                return this.createSetupHRProcess();
            }
            if ("onboarding.setupPayroll".equals(processId)) {
                return this.createSetupPayrollProcess();
            }
            return null;
        }

        public Collection<String> processIds() {
            return Arrays.asList("onboarding.onboarding", "onboarding.setupHR", "onboarding.setupPayroll");
        }

        public OnboardingProcess createOnboardingProcess() {
            return new OnboardingProcess(Application.this).configure();
        }

        public SetupHRProcess createSetupHRProcess() {
            return new SetupHRProcess(Application.this).configure();
        }

        public SetupPayrollProcess createSetupPayrollProcess() {
            return new SetupPayrollProcess(Application.this).configure();
        }
    }
}

