/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.onboarding;

import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.Model;
import org.kie.kogito.examples.Application;
import org.kie.kogito.examples.onboarding.Employee;
import org.kie.kogito.examples.onboarding.Payroll;
import org.kie.kogito.examples.onboarding.SetupPayrollModel;
import org.kie.kogito.examples.onboarding.SetupPayrollProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;

@Singleton
@Named(value="onboarding.setupPayroll")
public class SetupPayrollProcess
extends AbstractProcess<SetupPayrollModel> {
    @Inject
    Instance<WorkItemHandler> handlers;
    Application app;

    public SetupPayrollProcess() {
        this(new Application());
    }

    public SetupPayrollProcess(Application app) {
        super(app.config().process());
        this.app = app;
    }

    public SetupPayrollProcessInstance createInstance(SetupPayrollModel value) {
        return new SetupPayrollProcessInstance(this, value, this.createLegacyProcessRuntime());
    }

    public SetupPayrollModel createModel() {
        return new SetupPayrollModel();
    }

    public SetupPayrollProcessInstance createInstance(Model value) {
        return this.createInstance((SetupPayrollModel)value);
    }

    public SetupPayrollProcess configure() {
        return this;
    }

    protected Process legacyProcess() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"onboarding.setupPayroll");
        factory.variable("employee", (DataType)new ObjectDataType("org.kie.kogito.examples.onboarding.Employee"));
        factory.variable("payroll", (DataType)new ObjectDataType("org.kie.kogito.examples.onboarding.Payroll"));
        factory.variable("vacationDays", (DataType)new ObjectDataType("java.lang.Integer"));
        factory.variable("taxRate", (DataType)new ObjectDataType("java.lang.Double"));
        factory.variable("paymentDate", (DataType)new ObjectDataType("java.util.Date"));
        factory.name("setupPayroll");
        factory.packageName("org.kie.kogito.examples.onboarding");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Private");
        factory.metaData("Documentation", (Object)"Calculates payroll related data such as vacation days, tax rate, payment date, etc");
        factory.metaData("TargetNamespace", (Object)"http://www.omg.org/bpmn20");
        WorkItemNodeFactory workItemNode1 = factory.workItemNode(1L);
        workItemNode1.name("Calculate payment date");
        workItemNode1.workName("CalculatePaymentDate");
        workItemNode1.workParameter("TaskName", (Object)"CalculatePaymentDate");
        workItemNode1.workParameter("Model", (Object)"onboarding");
        workItemNode1.workParameter("Decision", (Object)"paymentDate");
        workItemNode1.workParameter("Namespace", (Object)"test");
        workItemNode1.inMapping("employee", "employee");
        workItemNode1.outMapping("paymentDate", "paymentDate");
        workItemNode1.done();
        workItemNode1.metaData("UniqueId", (Object)"_83EB46B5-7186-4575-8AA0-1A8FCCE1D163");
        workItemNode1.metaData("elementname", (Object)"Calculate payment date");
        workItemNode1.metaData("x", (Object)392);
        workItemNode1.metaData("width", (Object)154);
        workItemNode1.metaData("y", (Object)355);
        workItemNode1.metaData("height", (Object)102);
        JoinFactory joinNode2 = factory.joinNode(2L);
        joinNode2.name("Split");
        joinNode2.type(5);
        joinNode2.done();
        SplitFactory splitNode3 = factory.splitNode(3L);
        splitNode3.name("Split");
        splitNode3.type(3);
        splitNode3.metaData("UniqueId", (Object)"_FC492E95-B79A-4EE3-B7FC-0A0197516421");
        splitNode3.metaData("x", (Object)253);
        splitNode3.metaData("width", (Object)56);
        splitNode3.metaData("y", (Object)213);
        splitNode3.metaData("height", (Object)56);
        splitNode3.constraint(1L, "_B94F71D7-E34E-4513-B06D-33F6EF74C9E6", "DROOLS_DEFAULT", "java", kcontext -> {
            Employee employee = (Employee)kcontext.getVariable("employee");
            Payroll payroll = (Payroll)kcontext.getVariable("payroll");
            Integer vacationDays = (Integer)kcontext.getVariable("vacationDays");
            Double taxRate = (Double)kcontext.getVariable("taxRate");
            Date paymentDate = (Date)kcontext.getVariable("paymentDate");
            return employee.getAddress().getCountry().equalsIgnoreCase("US");
        }, 0);
        splitNode3.constraint(6L, "_622BF92E-6590-44B6-B83D-10C0D8067D09", "DROOLS_DEFAULT", "java", kcontext -> {
            Employee employee = (Employee)kcontext.getVariable("employee");
            Payroll payroll = (Payroll)kcontext.getVariable("payroll");
            Integer vacationDays = (Integer)kcontext.getVariable("vacationDays");
            Double taxRate = (Double)kcontext.getVariable("taxRate");
            Date paymentDate = (Date)kcontext.getVariable("paymentDate");
            return true;
        }, 0);
        splitNode3.constraint(4L, "_A9F2A40F-0EAD-4241-908B-F7A950DAC100", "DROOLS_DEFAULT", "java", kcontext -> {
            Employee employee = (Employee)kcontext.getVariable("employee");
            Payroll payroll = (Payroll)kcontext.getVariable("payroll");
            Integer vacationDays = (Integer)kcontext.getVariable("vacationDays");
            Double taxRate = (Double)kcontext.getVariable("taxRate");
            Date paymentDate = (Date)kcontext.getVariable("paymentDate");
            return true;
        }, 0);
        splitNode3.done();
        WorkItemNodeFactory workItemNode4 = factory.workItemNode(4L);
        workItemNode4.name("Calculate vacation days");
        workItemNode4.workName("CalculateVacationDays");
        workItemNode4.workParameter("TaskName", (Object)"CalculateVacationDays");
        workItemNode4.workParameter("Model", (Object)"onboarding");
        workItemNode4.workParameter("Namespace", (Object)"test");
        workItemNode4.workParameter("Decision", (Object)"vacationDays");
        workItemNode4.inMapping("employee", "employee");
        workItemNode4.outMapping("vacationDays", "vacationDays");
        workItemNode4.done();
        workItemNode4.metaData("UniqueId", (Object)"_AE1BFAA6-7AFD-455F-95B4-FA619A2095CF");
        workItemNode4.metaData("elementname", (Object)"Calculate vacation days");
        workItemNode4.metaData("Documentation", (Object)"Uses VacationDays decision service to calculate eligible vacation days for the employee");
        workItemNode4.metaData("x", (Object)392);
        workItemNode4.metaData("width", (Object)154);
        workItemNode4.metaData("y", (Object)25);
        workItemNode4.metaData("height", (Object)102);
        StartNodeFactory startNode5 = factory.startNode(5L);
        startNode5.name("Start");
        startNode5.done();
        WorkItemNodeFactory workItemNode6 = factory.workItemNode(6L);
        workItemNode6.name("Calculate tax rate");
        workItemNode6.workName("CalculateTaxRate");
        workItemNode6.workParameter("TaskName", (Object)"CalculateTaxRate");
        workItemNode6.workParameter("Model", (Object)"onboarding");
        workItemNode6.workParameter("Decision", (Object)"taxRate");
        workItemNode6.workParameter("Namespace", (Object)"test");
        workItemNode6.inMapping("employee", "employee");
        workItemNode6.outMapping("taxRate", "taxRate");
        workItemNode6.done();
        workItemNode6.metaData("UniqueId", (Object)"_D2DE6249-804E-432D-9600-6B0F618B457C");
        workItemNode6.metaData("elementname", (Object)"Calculate tax rate");
        workItemNode6.metaData("x", (Object)392);
        workItemNode6.metaData("width", (Object)154);
        workItemNode6.metaData("y", (Object)190);
        workItemNode6.metaData("height", (Object)102);
        ActionNodeFactory actionNode7 = factory.actionNode(7L);
        actionNode7.name("Payroll setup");
        actionNode7.action(kcontext -> {
            Employee employee = (Employee)kcontext.getVariable("employee");
            Payroll payroll = (Payroll)kcontext.getVariable("payroll");
            Integer vacationDays = (Integer)kcontext.getVariable("vacationDays");
            Double taxRate = (Double)kcontext.getVariable("taxRate");
            Date paymentDate = (Date)kcontext.getVariable("paymentDate");
            Payroll empPayroll = new Payroll(vacationDays, taxRate, paymentDate);
            kcontext.setVariable("payroll", (Object)empPayroll);
        });
        actionNode7.done();
        EndNodeFactory endNode8 = factory.endNode(8L);
        endNode8.name("End Event 1");
        endNode8.terminate(false);
        endNode8.done();
        factory.connection(3L, 1L, "_B94F71D7-E34E-4513-B06D-33F6EF74C9E6");
        factory.connection(1L, 2L, "_344D9BF6-D173-4BEC-943B-5E4394A6B6C7");
        factory.connection(4L, 2L, "_FDBE0EF0-FA3E-4FEC-8568-7E7A79A5289E");
        factory.connection(6L, 2L, "_7597C8A1-CC2B-4345-99A2-3F3A71C1FDA1");
        factory.connection(5L, 3L, "_299404B8-2860-4F4D-B970-48F6B17DA3E9");
        factory.connection(3L, 4L, "_A9F2A40F-0EAD-4241-908B-F7A950DAC100");
        factory.connection(3L, 6L, "_622BF92E-6590-44B6-B83D-10C0D8067D09");
        factory.connection(2L, 7L, "_7B55F281-D560-4130-88C9-177C960E8682");
        factory.connection(7L, 8L, "SequenceFlow_3");
        factory.validate();
        return factory.getProcess();
    }

    @PostConstruct
    public void init() {
        this.configure();
    }
}

