/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.onboarding;

import io.quarkus.runtime.StartupEvent;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.core.util.KieFunctions;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.FaultNodeFactory;
import org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.SubProcessNodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.jbpm.workflow.core.node.SubProcessFactory;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.Model;
import org.kie.kogito.examples.Application;
import org.kie.kogito.examples.onboarding.Employee;
import org.kie.kogito.examples.onboarding.OnboardingModel;
import org.kie.kogito.examples.onboarding.OnboardingProcessInstance;
import org.kie.kogito.examples.onboarding.Payroll;
import org.kie.kogito.examples.onboarding.SetupHRModel;
import org.kie.kogito.examples.onboarding.SetupPayrollModel;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;

@ApplicationScoped
@Named(value="onboarding.onboarding")
public class OnboardingProcess
extends AbstractProcess<OnboardingModel> {
    @Inject
    Instance<WorkItemHandler> handlers;
    Application app;
    @Inject
    org.kie.kogito.process.Process<SetupHRModel> processsetupHR;
    @Inject
    org.kie.kogito.process.Process<SetupPayrollModel> processsetupPayroll;

    public OnboardingProcess() {
    }

    @Inject
    public OnboardingProcess(Application app) {
        super(app.config().process());
        this.app = app;
    }

    public OnboardingProcessInstance createInstance(OnboardingModel value) {
        return new OnboardingProcessInstance(this, value, this.createLegacyProcessRuntime());
    }

    public OnboardingModel createModel() {
        return new OnboardingModel();
    }

    public OnboardingProcessInstance createInstance(Model value) {
        return this.createInstance((OnboardingModel)value);
    }

    public OnboardingProcess configure() {
        super.configure();
        return this;
    }

    protected void registerListeners() {
        this.services.getSignalManager().addEventListener("onboarding.setupHR", (EventListener)this.completionEventListener);
        this.services.getSignalManager().addEventListener("onboarding.setupPayroll", (EventListener)this.completionEventListener);
    }

    public Process legacyProcess() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"onboarding.onboarding");
        factory.variable("employee", (DataType)new ObjectDataType("org.kie.kogito.examples.onboarding.Employee"));
        factory.variable("payroll", (DataType)new ObjectDataType("org.kie.kogito.examples.onboarding.Payroll"));
        factory.variable("employeeId", (DataType)new ObjectDataType("java.lang.String"));
        factory.variable("email", (DataType)new ObjectDataType("java.lang.String"));
        factory.variable("status", (DataType)new ObjectDataType("java.lang.String"));
        factory.variable("message", (DataType)new ObjectDataType("java.lang.String"));
        factory.variable("manager", (DataType)new ObjectDataType("java.lang.String"));
        factory.variable("department", (DataType)new ObjectDataType("java.lang.String"));
        factory.name("onboarding");
        factory.packageName("org.kie.kogito.examples.onboarding");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        factory.metaData("TargetNamespace", (Object)"http://www.omg.org/bpmn20");
        SplitFactory splitNode1 = factory.splitNode(1L);
        splitNode1.name("Split");
        splitNode1.type(1);
        splitNode1.metaData("UniqueId", (Object)"_EEA9F9A8-BC9D-4DC3-B89A-28F79A0C6A48");
        splitNode1.metaData("x", (Object)801);
        splitNode1.metaData("width", (Object)56);
        splitNode1.metaData("y", (Object)232);
        splitNode1.metaData("height", (Object)56);
        splitNode1.done();
        StartNodeFactory startNode2 = factory.startNode(2L);
        startNode2.name("Start");
        startNode2.metaData("UniqueId", (Object)"_1EA961BC-6E42-4F0E-ACC4-B3A06137B9E8");
        startNode2.metaData("x", (Object)90);
        startNode2.metaData("width", (Object)56);
        startNode2.metaData("y", (Object)232);
        startNode2.metaData("height", (Object)56);
        startNode2.done();
        HumanTaskNodeFactory humanTaskNode3 = factory.humanTaskNode(3L);
        humanTaskNode3.name("Manager confirmation");
        humanTaskNode3.workParameter("TaskName", (Object)"ManagerConfirmation");
        humanTaskNode3.workParameter("Skippable", (Object)"false");
        humanTaskNode3.workParameter("ActorId", (Object)"manager");
        humanTaskNode3.workParameter("NodeName", (Object)"Manager confirmation");
        humanTaskNode3.inMapping("depeartment", "department");
        humanTaskNode3.inMapping("employeeId", "employeeId");
        humanTaskNode3.inMapping("payroll", "payroll");
        humanTaskNode3.inMapping("employee", "employee");
        humanTaskNode3.inMapping("email", "email");
        humanTaskNode3.outMapping("message", "message");
        humanTaskNode3.outMapping("status", "status");
        humanTaskNode3.done();
        humanTaskNode3.metaData("UniqueId", (Object)"_55258880-C191-4643-AC16-A0F5C1B05956");
        humanTaskNode3.metaData("elementname", (Object)"Manager confirmation");
        humanTaskNode3.metaData("x", (Object)1162);
        humanTaskNode3.metaData("width", (Object)154);
        humanTaskNode3.metaData("y", (Object)336);
        humanTaskNode3.metaData("height", (Object)102);
        SplitFactory splitNode4 = factory.splitNode(4L);
        splitNode4.name("Split");
        splitNode4.type(2);
        splitNode4.metaData("UniqueId", (Object)"_32221BB1-BAE5-4431-8003-3FEF0E04D9C7");
        splitNode4.metaData("x", (Object)431);
        splitNode4.metaData("width", (Object)56);
        splitNode4.metaData("y", (Object)232);
        splitNode4.metaData("Default", (Object)"_A65F4850-A93F-4703-B5AA-2EF5F649BC86");
        splitNode4.metaData("height", (Object)56);
        splitNode4.constraint(10L, "_5F4F4E2D-B4EC-4542-91DF-69FC30C5E346", "DROOLS_DEFAULT", "java", kcontext -> {
            Employee employee = (Employee)kcontext.getVariable("employee");
            Payroll payroll = (Payroll)kcontext.getVariable("payroll");
            String employeeId = (String)kcontext.getVariable("employeeId");
            String email = (String)kcontext.getVariable("email");
            String status = (String)kcontext.getVariable("status");
            String message = (String)kcontext.getVariable("message");
            String manager = (String)kcontext.getVariable("manager");
            String department = (String)kcontext.getVariable("department");
            return KieFunctions.equalsTo((String)status, (String)"exists");
        }, 0);
        splitNode4.constraint(11L, "_A65F4850-A93F-4703-B5AA-2EF5F649BC86", "DROOLS_DEFAULT", "java", kcontext -> {
            Employee employee = (Employee)kcontext.getVariable("employee");
            Payroll payroll = (Payroll)kcontext.getVariable("payroll");
            String employeeId = (String)kcontext.getVariable("employeeId");
            String email = (String)kcontext.getVariable("email");
            String status = (String)kcontext.getVariable("status");
            String message = (String)kcontext.getVariable("message");
            String manager = (String)kcontext.getVariable("manager");
            String department = (String)kcontext.getVariable("department");
            return KieFunctions.equalsTo((String)status, (String)"new");
        }, 0);
        splitNode4.done();
        SubProcessNodeFactory subProcessNode5 = factory.subProcessNode(5L);
        subProcessNode5.name("Setup HR");
        subProcessNode5.processId("onboarding.setupHR");
        subProcessNode5.processName("");
        subProcessNode5.waitForCompletion(true);
        subProcessNode5.independent(false);
        subProcessNode5.subProcessFactory((SubProcessFactory)new SubProcessFactory<SetupHRModel>(){

            public SetupHRModel bind(ProcessContext kcontext) {
                SetupHRModel model = new SetupHRModel();
                Employee employee = (Employee)kcontext.getVariable("employee");
                model.setEmployee(employee);
                return model;
            }

            public ProcessInstance<SetupHRModel> createInstance(SetupHRModel model) {
                return OnboardingProcess.this.processsetupHR.createInstance((Object)model);
            }

            public void unbind(ProcessContext kcontext, SetupHRModel model) {
                String manager = model.getManager();
                kcontext.setVariable("manager", (Object)manager);
                String department = model.getDepartment();
                kcontext.setVariable("department", (Object)department);
            }
        });
        subProcessNode5.metaData("UniqueId", (Object)"_14472369-3EAD-4B2D-9C3B-F83D4630C59B");
        subProcessNode5.metaData("elementname", (Object)"Setup HR");
        subProcessNode5.metaData("x", (Object)929);
        subProcessNode5.metaData("width", (Object)153);
        subProcessNode5.metaData("y", (Object)337);
        subProcessNode5.metaData("height", (Object)101);
        subProcessNode5.done();
        EndNodeFactory endNode6 = factory.endNode(6L);
        endNode6.name("End");
        endNode6.terminate(false);
        endNode6.metaData("UniqueId", (Object)"_F6920526-06EC-43CD-A743-17778DEB7363");
        endNode6.metaData("x", (Object)1501);
        endNode6.metaData("width", (Object)56);
        endNode6.metaData("y", (Object)232);
        endNode6.metaData("height", (Object)56);
        endNode6.done();
        WorkItemNodeFactory workItemNode7 = factory.workItemNode(7L);
        workItemNode7.name("Validate employee");
        workItemNode7.workName("ValidateEmployee");
        workItemNode7.workParameter("Decision", (Object)"employeeValidation");
        workItemNode7.workParameter("Model", (Object)"onboarding");
        workItemNode7.workParameter("Namespace", (Object)"test");
        workItemNode7.workParameter("TaskName", (Object)"ValidateEmployee");
        workItemNode7.inMapping("employee", "employee");
        workItemNode7.outMapping("message", "message");
        workItemNode7.outMapping("status", "status");
        workItemNode7.done();
        workItemNode7.metaData("UniqueId", (Object)"_DD24B4AE-8804-4D6E-B90B-98689CF6EF37");
        workItemNode7.metaData("elementname", (Object)"Validate employee");
        workItemNode7.metaData("x", (Object)197);
        workItemNode7.metaData("width", (Object)154);
        workItemNode7.metaData("y", (Object)209);
        workItemNode7.metaData("height", (Object)102);
        SubProcessNodeFactory subProcessNode8 = factory.subProcessNode(8L);
        subProcessNode8.name("Setup Payroll");
        subProcessNode8.processId("onboarding.setupPayroll");
        subProcessNode8.processName("");
        subProcessNode8.waitForCompletion(true);
        subProcessNode8.independent(false);
        subProcessNode8.subProcessFactory((SubProcessFactory)new SubProcessFactory<SetupPayrollModel>(){

            public SetupPayrollModel bind(ProcessContext kcontext) {
                SetupPayrollModel model = new SetupPayrollModel();
                Employee employee = (Employee)kcontext.getVariable("employee");
                model.setEmployee(employee);
                return model;
            }

            public ProcessInstance<SetupPayrollModel> createInstance(SetupPayrollModel model) {
                return OnboardingProcess.this.processsetupPayroll.createInstance((Object)model);
            }

            public void unbind(ProcessContext kcontext, SetupPayrollModel model) {
                Payroll payroll = model.getPayroll();
                kcontext.setVariable("payroll", (Object)payroll);
            }
        });
        subProcessNode8.metaData("UniqueId", (Object)"_9D7A4927-BFCB-4F17-A4D4-E3D03B3FBE49");
        subProcessNode8.metaData("elementname", (Object)"Setup Payroll");
        subProcessNode8.metaData("x", (Object)929);
        subProcessNode8.metaData("width", (Object)153);
        subProcessNode8.metaData("y", (Object)81);
        subProcessNode8.metaData("height", (Object)101);
        subProcessNode8.done();
        JoinFactory joinNode9 = factory.joinNode(9L);
        joinNode9.name("Join");
        joinNode9.type(1);
        joinNode9.metaData("UniqueId", (Object)"_E918E3F5-CB0B-4875-AD72-5C8337D3C69A");
        joinNode9.metaData("x", (Object)1365);
        joinNode9.metaData("width", (Object)56);
        joinNode9.metaData("y", (Object)232);
        joinNode9.metaData("height", (Object)56);
        joinNode9.done();
        FaultNodeFactory faultNode10 = factory.faultNode(10L);
        faultNode10.name("Error");
        faultNode10.setFaultName("Rejected");
        faultNode10.metaData("UniqueId", (Object)"_469F11CB-CA82-4CA0-ACC4-127F6B3727F1");
        faultNode10.metaData("x", (Object)537);
        faultNode10.metaData("width", (Object)56);
        faultNode10.metaData("y", (Object)451);
        faultNode10.metaData("height", (Object)56);
        faultNode10.done();
        WorkItemNodeFactory workItemNode11 = factory.workItemNode(11L);
        workItemNode11.name("Assign id and email");
        workItemNode11.workName("AssignIdAndEmail");
        workItemNode11.workParameter("Decision", (Object)"id");
        workItemNode11.workParameter("Model", (Object)"onboarding");
        workItemNode11.workParameter("Namespace", (Object)"test");
        workItemNode11.workParameter("TaskName", (Object)"AssignIdAndEmail");
        workItemNode11.inMapping("employee", "employee");
        workItemNode11.outMapping("employeeId", "employeeId");
        workItemNode11.outMapping("email", "email");
        workItemNode11.done();
        workItemNode11.metaData("UniqueId", (Object)"_16FFBBF8-8373-46D4-A278-F305AFA7F4B1");
        workItemNode11.metaData("elementname", (Object)"Assign id and email");
        workItemNode11.metaData("x", (Object)567);
        workItemNode11.metaData("width", (Object)154);
        workItemNode11.metaData("y", (Object)209);
        workItemNode11.metaData("height", (Object)102);
        factory.connection(11L, 1L, "_7DF7D2C1-195D-4C19-BC47-CC4462F9062D");
        factory.connection(5L, 3L, "_D32B4A20-53D1-46F3-95F6-276A2392931F");
        factory.connection(7L, 4L, "_5A442C9F-BADA-4D95-9ECA-3BD2898C8377");
        factory.connection(1L, 5L, "_D5E3808E-4D68-4B8F-939D-17C7643E58FD");
        factory.connection(9L, 6L, "_3CFB2AC2-17B6-4322-ACD8-C9A149975143");
        factory.connection(2L, 7L, "_9D72C909-B631-415E-B015-30812A42B8C2");
        factory.connection(1L, 8L, "_DF6979D3-AFD3-4BC8-A866-8B9214F7F0FB");
        factory.connection(3L, 9L, "_44ABA3C5-9A26-4843-B03B-99C2C0251707");
        factory.connection(8L, 9L, "_BB67B9E9-611B-4B17-A6F9-3CD4DCA4B249");
        factory.connection(4L, 10L, "_5F4F4E2D-B4EC-4542-91DF-69FC30C5E346");
        factory.connection(4L, 11L, "_A65F4850-A93F-4703-B5AA-2EF5F649BC86");
        factory.validate();
        return factory.getProcess();
    }

    public void init(@Observes StartupEvent event) {
        this.configure();
    }
}

