/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.onboarding;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.Application;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.onboarding.OnboardingModel;
import org.kie.kogito.examples.onboarding.Onboarding_3_TaskInput;
import org.kie.kogito.examples.onboarding.Onboarding_3_TaskOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;

@Path(value="/onboarding")
@ApplicationScoped
public class OnboardingResource {
    @Inject
    @Named(value="onboarding.onboarding")
    Process<OnboardingModel> process;
    @Inject
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public OnboardingModel createResource_onboarding(OnboardingModel resource) {
        if (resource == null) {
            resource = new OnboardingModel();
        }
        OnboardingModel value = resource;
        return (OnboardingModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.createInstance((Object)value);
            pi.start();
            return this.getModel((ProcessInstance<OnboardingModel>)pi);
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<OnboardingModel> getResources_onboarding() {
        return this.process.instances().values().stream().map(ProcessInstance::variables).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public OnboardingModel getResource_onboarding(@PathParam(value="id") String id) {
        return this.process.instances().findById(id).map(ProcessInstance::variables).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public OnboardingModel deleteResource_onboarding(@PathParam(value="id") String id) {
        return (OnboardingModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.abort();
            return this.getModel((ProcessInstance<OnboardingModel>)pi);
        });
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OnboardingModel updateModel_onboarding(@PathParam(value="id") String id, OnboardingModel resource) {
        return (OnboardingModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.updateVariables((Object)resource);
            return (OnboardingModel)pi.variables();
        });
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<String, String> getTasks_onboarding(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> pi.workItems(this.policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected OnboardingModel getModel(ProcessInstance<OnboardingModel> pi) {
        if (pi.status() == 5 && pi.error().isPresent()) {
            throw new ProcessInstanceExecutionException(pi.id(), ((ProcessError)pi.error().get()).failedNodeId(), ((ProcessError)pi.error().get()).errorMessage());
        }
        return (OnboardingModel)pi.variables();
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        StaticIdentityProvider identity = null;
        if (user != null) {
            identity = new StaticIdentityProvider(user, groups);
        }
        return new Policy[]{SecurityPolicy.of((IdentityProvider)identity)};
    }

    @POST
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OnboardingModel completeTask_3(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, Onboarding_3_TaskOutput model) {
        try {
            return (OnboardingModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, model.toMap(), (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel((ProcessInstance<OnboardingModel>)pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Produces(value={"application/json"})
    public Onboarding_3_TaskInput getTask_3(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, this.policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return Onboarding_3_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Produces(value={"application/json"})
    public OnboardingModel abortTask_3(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            return (OnboardingModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, null, (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel((ProcessInstance<OnboardingModel>)pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}

