package testscorecard.simplescorecard;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.expressions.*;
import org.kie.pmml.commons.transformations.*;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.models.drools.scorecard.model.KiePMMLScorecardModel;

public class SimpleScorecard extends KiePMMLScorecardModel {

    public SimpleScorecard() {
        super("SimpleScorecard", Collections.emptyList());
        targetField = "score";
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.SCORECARD_MODEL;
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.REGRESSION;
        transformationDictionary = null;
        localTransformations = null;
        kiePMMLOutputFields = this.getCreatedKiePMMLOutputFields();
        fieldTypeMap.put("score", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "SCORE"));
        fieldTypeMap.put("input2", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "INPUT2"));
        fieldTypeMap.put("input1", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "INPUT1"));
        miningFields.add(new org.kie.pmml.api.models.MiningField("input1", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("input2", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("score", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.TARGET, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("Score", org.kie.pmml.api.enums.OP_TYPE.CONTINUOUS, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, "score", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("Reason Code 1", org.kie.pmml.api.enums.OP_TYPE.CATEGORICAL, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.RESULT_FEATURE.REASON_CODE, null));
        outputFields.add(new org.kie.pmml.api.models.OutputField("Reason Code 2", org.kie.pmml.api.enums.OP_TYPE.CATEGORICAL, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.RESULT_FEATURE.REASON_CODE, null));
    }

    @Override
    public String getKModulePackageName() {
        return "testscorecard.simplescorecard";
    }

    private List<KiePMMLOutputField> getCreatedKiePMMLOutputFields() {
        KiePMMLOutputField score = KiePMMLOutputField.builder("Score", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).withTargetField("score").withValue(null).withRank(1).withKiePMMLExpression(null).build();
        KiePMMLOutputField reasoncode1 = KiePMMLOutputField.builder("Reason Code 1", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.REASON_CODE).withTargetField(null).withValue(null).withRank(1).withKiePMMLExpression(null).build();
        KiePMMLOutputField reasoncode2 = KiePMMLOutputField.builder("Reason Code 2", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.REASON_CODE).withTargetField(null).withValue(null).withRank(2).withKiePMMLExpression(null).build();
        return Arrays.asList(score, reasoncode1, reasoncode2);
    }
}
