package testminingmodel.predicatesmining;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.pmml.commons.model.KiePMMLMiningField;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.expressions.*;
import org.kie.pmml.commons.transformations.*;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;

public class PredicatesMining extends KiePMMLMiningModel {

    public PredicatesMining() {
        super("PredicatesMining", Collections.emptyList());
        targetField = "categoricalResult";
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.REGRESSION;
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.MINING_MODEL;
        segmentation = new testminingmodel.predicatesmining.predicatesminingsegmentation.PredicatesMiningSegmentation();
        transformationDictionary = null;
        localTransformations = null;
        kiePMMLMiningFields = this.getCreatedKiePMMLMiningFields();
        kiePMMLOutputFields = null;
        miningFields.add(new org.kie.pmml.api.models.MiningField("categoricalResult", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("categoricalX", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList("red", "green", "blue", "orange", "yellow"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("categoricalY", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList("classA", "classB", "classC"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("age", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("occupation", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList("SKYDIVER", "ASTRONAUT", "PROGRAMMER", "TEACHER", "INSTRUCTOR"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("residenceState", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList("AP", "KN", "TN"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("validLicense", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.BOOLEAN, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("variable", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
    }

    private List<KiePMMLMiningField> getCreatedKiePMMLMiningFields() {
        KiePMMLMiningField categoricalresult = KiePMMLMiningField.builder("categoricalResult", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField categoricalx = KiePMMLMiningField.builder("categoricalX", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList("red", "green", "blue", "orange", "yellow")).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField categoricaly = KiePMMLMiningField.builder("categoricalY", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList("classA", "classB", "classC")).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField age = KiePMMLMiningField.builder("age", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField occupation = KiePMMLMiningField.builder("occupation", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList("SKYDIVER", "ASTRONAUT", "PROGRAMMER", "TEACHER", "INSTRUCTOR")).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField residencestate = KiePMMLMiningField.builder("residenceState", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList("AP", "KN", "TN")).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField validlicense = KiePMMLMiningField.builder("validLicense", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.BOOLEAN).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField variable = KiePMMLMiningField.builder("variable", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        return Arrays.asList(categoricalresult, categoricalx, categoricaly, age, occupation, residencestate, validlicense, variable);
    }
}
