package testscorecard.simplescorecard;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.REASONCODE_ALGORITHM;
import org.kie.pmml.commons.model.*;
import org.kie.pmml.commons.model.expressions.*;
import org.kie.pmml.commons.transformations.*;
import org.kie.pmml.models.scorecard.model.KiePMMLScorecardModel;

public class SimpleScorecard extends KiePMMLScorecardModel {

    public SimpleScorecard() {
        super("SimpleScorecard", Collections.emptyList(), new testscorecard.simplescorecard.Characteristicse376f445632f469d82da48061c183b7d(), 5, true, org.kie.pmml.api.enums.REASONCODE_ALGORITHM.POINTS_BELOW, null);
        targetField = "score";
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.SCORECARD_MODEL;
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.REGRESSION;
        transformationDictionary = null;
        localTransformations = null;
        kiePMMLMiningFields = this.getCreatedKiePMMLMiningFields();
        kiePMMLOutputFields = this.getCreatedKiePMMLOutputFields();
        miningFields.add(new org.kie.pmml.api.models.MiningField("input1", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("input2", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("score", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.TARGET, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID, null, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("Score", org.kie.pmml.api.enums.OP_TYPE.CONTINUOUS, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, "score", org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE, java.util.Arrays.asList()));
        outputFields.add(new org.kie.pmml.api.models.OutputField("Reason Code 1", org.kie.pmml.api.enums.OP_TYPE.CATEGORICAL, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.RESULT_FEATURE.REASON_CODE, null));
        outputFields.add(new org.kie.pmml.api.models.OutputField("Reason Code 2", org.kie.pmml.api.enums.OP_TYPE.CATEGORICAL, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, org.kie.pmml.api.enums.RESULT_FEATURE.REASON_CODE, null));
    }

    private List<KiePMMLMiningField> getCreatedKiePMMLMiningFields() {
        KiePMMLMiningField input1 = KiePMMLMiningField.builder("input1", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField input2 = KiePMMLMiningField.builder("input2", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.AS_MISSING).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        KiePMMLMiningField score = KiePMMLMiningField.builder("score", Collections.emptyList()).withFieldUsageType(org.kie.pmml.api.enums.FIELD_USAGE_TYPE.TARGET).withOpType(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withMissingValueTreatmentMethod(null).withInvalidValueTreatmentMethod(org.kie.pmml.api.enums.INVALID_VALUE_TREATMENT_METHOD.RETURN_INVALID).withMissingValueReplacement(null).withInvalidValueReplacement(null).withAllowedValues(Arrays.asList()).withIntervals(Arrays.asList()).build();
        return Arrays.asList(input1, input2, score);
    }

    private List<KiePMMLOutputField> getCreatedKiePMMLOutputFields() {
        KiePMMLOutputField score = KiePMMLOutputField.builder("Score", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.PREDICTED_VALUE).withTargetField("score").withValue(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.DOUBLE).withRank(1).withKiePMMLExpression(null).build();
        KiePMMLOutputField reasoncode1 = KiePMMLOutputField.builder("Reason Code 1", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.REASON_CODE).withTargetField(null).withValue(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withRank(1).withKiePMMLExpression(null).build();
        KiePMMLOutputField reasoncode2 = KiePMMLOutputField.builder("Reason Code 2", Collections.emptyList()).withResultFeature(org.kie.pmml.api.enums.RESULT_FEATURE.REASON_CODE).withTargetField(null).withValue(null).withDataType(org.kie.pmml.api.enums.DATA_TYPE.STRING).withRank(2).withKiePMMLExpression(null).build();
        return Arrays.asList(score, reasoncode1, reasoncode2);
    }
}
