/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.springboot.example;

import io.restassured.RestAssured;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.pmml.springboot.example.CommonTestUtils;
import org.kie.kogito.pmml.springboot.example.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
class MiningModelTest {
    private static final String BASE_PATH = "/PredicatesMining";
    private static final String TARGET = "categoricalResult";
    @LocalServerPort
    private int port;

    MiningModelTest() {
    }

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    void testEvaluatePredicatesMiningResult() {
        String inputData = "{\"residenceState\":\"AP\", \"validLicense\":true, \"occupation\":\"ASTRONAUT\", \"categoricalY\":\"classA\", \"categoricalX\":\"red\", \"variable\":6.6, \"age\":25.0}";
        CommonTestUtils.testResult(inputData, BASE_PATH, TARGET, Float.valueOf(1.3816667f));
    }

    @Test
    void testEvaluatePredicatesMiningDescriptive() {
        String inputData = "{\"residenceState\":\"AP\", \"validLicense\":true, \"occupation\":\"ASTRONAUT\", \"categoricalY\":\"classA\", \"categoricalX\":\"red\", \"variable\":6.6, \"age\":25.0}";
        Map<String, Object> expectedResultMap = Collections.singletonMap(TARGET, Float.valueOf(1.3816667f));
        CommonTestUtils.testDescriptive(inputData, BASE_PATH, TARGET, expectedResultMap);
    }
}

