/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.springboot.example;

import io.restassured.RestAssured;
import java.util.HashMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.pmml.springboot.example.CommonTestUtils;
import org.kie.kogito.pmml.springboot.example.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
class SampleMineTest {
    private static final String BASE_PATH = "/SampleMine";
    private static final String TARGET = "decision";
    @LocalServerPort
    private int port;

    SampleMineTest() {
    }

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    void testEvaluateSampleMineResult() {
        String inputData = "{\"temperature\":30.0, \"humidity\":10.0}";
        CommonTestUtils.testResult(inputData, BASE_PATH, TARGET, "sunglasses");
    }

    @Test
    void testEvaluateSampleMineDescriptive() {
        String inputData = "{\"temperature\":30.0, \"humidity\":10.0}";
        HashMap<String, Object> expectedResultMap = new HashMap<String, Object>();
        expectedResultMap.put(TARGET, "sunglasses");
        expectedResultMap.put("weatherdecision", "sunglasses");
        CommonTestUtils.testDescriptive(inputData, BASE_PATH, TARGET, expectedResultMap);
    }
}

