/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.kogito.springboot.example;

import io.restassured.RestAssured;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.pmml.kogito.springboot.example.CommonTestUtils;
import org.kie.pmml.kogito.springboot.example.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
class LinRegTest {
    private static final String BASE_PATH = "/LinReg";
    private static final String TARGET = "fld4";
    @LocalServerPort
    private int port;

    LinRegTest() {
    }

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    void testEvaluateLinRegResult() {
        String inputData = "{\"fld1\":3.0, \"fld2\":2.0, \"fld3\":\"y\"}";
        CommonTestUtils.testResult(inputData, BASE_PATH, TARGET, Float.valueOf(52.5f));
    }

    @Test
    void testEvaluateLinRegDescriptive() {
        String inputData = "{\"fld1\":3.0, \"fld2\":2.0, \"fld3\":\"y\"}";
        Map<String, Object> expectedResultMap = Collections.singletonMap(TARGET, Float.valueOf(52.5f));
        CommonTestUtils.testDescriptive(inputData, BASE_PATH, TARGET, expectedResultMap);
    }
}

