package testminingmodel.predicatesmining;

import java.util.Arrays;
import java.util.Collections;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.expressions.*;
import org.kie.pmml.commons.transformations.*;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;

public class PredicatesMining extends KiePMMLMiningModel {

    public PredicatesMining() {
        super("PredicatesMining", Collections.emptyList());
        targetField = "categoricalResult";
        miningFunction = org.kie.pmml.api.enums.MINING_FUNCTION.REGRESSION;
        pmmlMODEL = org.kie.pmml.api.enums.PMML_MODEL.MINING_MODEL;
        segmentation = new testminingmodel.predicatesmining.predicatesminingsegmentation.PredicatesMiningSegmentation();
        transformationDictionary = null;
        localTransformations = null;
        miningFields.add(new org.kie.pmml.api.models.MiningField("categoricalResult", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.PREDICTED, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("categoricalX", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, java.util.Arrays.asList("red", "green", "blue", "orange", "yellow"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("categoricalY", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, java.util.Arrays.asList("classA", "classB", "classC"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("age", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("occupation", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, java.util.Arrays.asList("SKYDIVER", "ASTRONAUT", "PROGRAMMER", "TEACHER", "INSTRUCTOR"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("residenceState", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.STRING, null, java.util.Arrays.asList("AP", "KN", "TN"), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("validLicense", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.BOOLEAN, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
        miningFields.add(new org.kie.pmml.api.models.MiningField("variable", org.kie.pmml.api.enums.FIELD_USAGE_TYPE.ACTIVE, null, org.kie.pmml.api.enums.DATA_TYPE.DOUBLE, null, java.util.Arrays.asList(), java.util.Arrays.asList()));
    }
}
