/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.acme.travels.Person;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;

@QuarkusTest
public class PersonProcessTest {
    @Inject
    @Named(value="persons")
    Process<? extends Model> personProcess;

    @Test
    public void testAdult() {
        Model m = (Model)this.personProcess.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("John Doe", 20));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.personProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)1, (int)result.toMap().size());
        Assertions.assertTrue((boolean)((Person)result.toMap().get("person")).isAdult());
    }

    @Test
    public void testChild() {
        Model m = (Model)this.personProcess.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("Jenny Quark", 14));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.personProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)1, (int)result.toMap().size());
        Assertions.assertFalse((boolean)((Person)result.toMap().get("person")).isAdult());
        List workItems = processInstance.workItems(new Policy[0]);
        Assertions.assertEquals((int)1, (int)workItems.size());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.status());
    }
}

