/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.traffic;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.math.BigDecimal;
import java.util.HashMap;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.kie.kogito.traffic.Violation;

@QuarkusTest
public class TrafficProcessIT {
    public static final BigDecimal SPEED_LIMIT = new BigDecimal(100);

    @Test
    public void testTrafficViolationEmbeddedDecisionOnQuarkus() {
        this.testTrafficProcess("traffic", "12345", 120.0, "No", true);
        this.testTrafficProcess("traffic", "12345", 140.0, "Yes", true);
        this.testTrafficProcess("traffic", "1234", 140.0, null, false);
    }

    private void testTrafficProcess(String processId, String driverId, Double speed, String suspended, Boolean validLicense) {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("driverId", driverId);
        request.put("violation", (String)new Violation("speed", SPEED_LIMIT, new BigDecimal(speed)));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(request).contentType(ContentType.JSON).when().post("/" + processId, new Object[0])).then()).statusCode(201)).body("suspended", Matchers.is((Object)suspended), new Object[0])).body("driver.validLicense", Matchers.is((Object)validLicense), new Object[0]);
    }
}

