package com.example;

import org.kie.api.definition.process.Process;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.util.KieFunctions;
import org.jbpm.process.core.datatype.impl.type.StringDataType;

@org.springframework.stereotype.Component("traffic")
public class TrafficProcess extends org.kie.kogito.process.impl.AbstractProcess<com.example.TrafficModel> {

    public TrafficProcess(org.kie.kogito.app.Application app, org.kie.kogito.correlation.CorrelationService correlations) {
        this(app, correlations, new org.kie.kogito.handlers.DriverService_getDriver_4_Handler());
    }

    @org.springframework.beans.factory.annotation.Autowired()
    public TrafficProcess(org.kie.kogito.app.Application app, org.kie.kogito.correlation.CorrelationService correlations, org.kie.kogito.handlers.DriverService_getDriver_4_Handler driverService_getDriver_4_Handler) {
        super(app, java.util.Arrays.asList(driverService_getDriver_4_Handler), correlations);
        activate();
    }

    public TrafficProcess() {
    }

    @Override()
    public com.example.TrafficProcessInstance createInstance(com.example.TrafficModel value) {
        return new com.example.TrafficProcessInstance(this, value, this.createProcessRuntime());
    }

    public com.example.TrafficProcessInstance createInstance(java.lang.String businessKey, com.example.TrafficModel value) {
        return new com.example.TrafficProcessInstance(this, value, businessKey, this.createProcessRuntime());
    }

    public com.example.TrafficProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.correlation.CompositeCorrelation correlation, com.example.TrafficModel value) {
        return new com.example.TrafficProcessInstance(this, value, businessKey, this.createProcessRuntime(), correlation);
    }

    @Override()
    public com.example.TrafficModel createModel() {
        return new com.example.TrafficModel();
    }

    public com.example.TrafficProcessInstance createInstance(org.kie.kogito.Model value) {
        return this.createInstance((com.example.TrafficModel) value);
    }

    public com.example.TrafficProcessInstance createInstance(java.lang.String businessKey, org.kie.kogito.Model value) {
        return this.createInstance(businessKey, (com.example.TrafficModel) value);
    }

    public com.example.TrafficProcessInstance createInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new com.example.TrafficProcessInstance(this, this.createModel(), this.createProcessRuntime(), wpi);
    }

    public com.example.TrafficProcessInstance createReadOnlyInstance(org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        return new com.example.TrafficProcessInstance(this, this.createModel(), wpi);
    }

    protected org.kie.api.definition.process.Process process() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess("traffic", true);
        factory.variable("suspended", org.jbpm.process.core.datatype.DataTypeResolver.fromClass(java.lang.String.class), null, "customTags", null);
        factory.variable("driverId", org.jbpm.process.core.datatype.DataTypeResolver.fromClass(java.lang.String.class), null, "customTags", null);
        factory.variable("violation", org.jbpm.process.core.datatype.DataTypeResolver.fromClass(org.kie.kogito.traffic.Violation.class), null, "customTags", null);
        factory.variable("driver", org.jbpm.process.core.datatype.DataTypeResolver.fromClass(org.kie.kogito.traffic.Driver.class), null, "customTags", null);
        factory.variable("fine", org.jbpm.process.core.datatype.DataTypeResolver.fromClass(org.kie.kogito.traffic.Fine.class), null, "customTags", null);
        factory.name("traffic");
        factory.packageName("com.example");
        factory.dynamic(false);
        factory.version("1.0");
        factory.type("BPMN");
        factory.visibility("Public");
        factory.metaData("TargetNamespace", "http://www.omg.org/bpmn20");
        org.jbpm.ruleflow.core.factory.EndNodeFactory<?> endNode1 = factory.endNode(1);
        endNode1.name("End");
        endNode1.terminate(false);
        endNode1.metaData("UniqueId", "_E2A8304B-68A0-4CCC-8D47-1FA9352D4853");
        endNode1.metaData("x", 637);
        endNode1.metaData("width", 56);
        endNode1.metaData("y", 416);
        endNode1.metaData("height", 56);
        endNode1.done();
        org.jbpm.ruleflow.core.factory.SplitFactory<?> splitNode2 = factory.splitNode(2);
        splitNode2.name("Split");
        splitNode2.type(2);
        splitNode2.metaData("UniqueId", "_7229480F-BC4D-4406-B27C-8FF46C5C9042");
        splitNode2.metaData("x", 637);
        splitNode2.metaData("width", 56);
        splitNode2.metaData("y", 227);
        splitNode2.metaData("Default", null);
        splitNode2.metaData("height", 56);
        splitNode2.constraint(10, "_8A36870E-651D-4E0A-B345-D5CFF2182F0F", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.String suspended = (java.lang.String) kcontext.getVariable("suspended");
            java.lang.String driverId = (java.lang.String) kcontext.getVariable("driverId");
            org.kie.kogito.traffic.Violation violation = (org.kie.kogito.traffic.Violation) kcontext.getVariable("violation");
            org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) kcontext.getVariable("driver");
            org.kie.kogito.traffic.Fine fine = (org.kie.kogito.traffic.Fine) kcontext.getVariable("fine");
            return driver.isValidLicense();
        }, 0, false);
        splitNode2.constraint(1, "_044AA388-325A-45DE-B783-4F48421B788B", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.String suspended = (java.lang.String) kcontext.getVariable("suspended");
            java.lang.String driverId = (java.lang.String) kcontext.getVariable("driverId");
            org.kie.kogito.traffic.Violation violation = (org.kie.kogito.traffic.Violation) kcontext.getVariable("violation");
            org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) kcontext.getVariable("driver");
            org.kie.kogito.traffic.Fine fine = (org.kie.kogito.traffic.Fine) kcontext.getVariable("fine");
            return !driver.isValidLicense();
        }, 0, false);
        splitNode2.done();
        org.jbpm.ruleflow.core.factory.RuleSetNodeFactory<?> ruleSetNode3 = factory.ruleSetNode(3);
        ruleSetNode3.name("LicenseValidation\nDRL");
        ruleSetNode3.ruleUnit("org.kie.kogito.traffic.LicenseValidationService", new org.jbpm.workflow.core.node.RuleUnitFactory<org.kie.kogito.traffic.LicenseValidationService>() {

            public org.kie.kogito.traffic.LicenseValidationService bind(org.kie.api.runtime.process.ProcessContext kcontext) {
                org.kie.kogito.traffic.LicenseValidationService unit = new org.kie.kogito.traffic.LicenseValidationService();
                {
                    org.kie.kogito.rules.SingletonStore unit_driver = unit.getDriver();
                    unit_driver.set((org.kie.kogito.traffic.Driver) (kcontext.getVariable("driver")));
                }
                org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) (kcontext.getVariable("driver"));
                {
                    org.kie.kogito.rules.SingletonStore unit_driver = unit.getDriver();
                    unit_driver.subscribe(org.kie.kogito.rules.DataObserver.ofUpdatable(o -> kcontext.setVariable("driver", o)));
                }
                return unit;
            }

            public org.kie.kogito.rules.RuleUnit<org.kie.kogito.traffic.LicenseValidationService> unit() {
                return app.get(org.kie.kogito.rules.RuleUnits.class).create(org.kie.kogito.traffic.LicenseValidationService.class);
            }

            public void unbind(org.kie.api.runtime.process.ProcessContext kcontext, org.kie.kogito.traffic.LicenseValidationService unit) {
                org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) (kcontext.getVariable("driver"));
                {
                    org.kie.kogito.rules.SingletonStore unit_driver = unit.getDriver();
                    unit_driver.subscribe(org.kie.kogito.rules.DataObserver.ofUpdatable(o -> kcontext.setVariable("driver", o)));
                }
            }
        });
        ruleSetNode3.mapDataInputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(new org.jbpm.workflow.core.impl.DataDefinition("driver", "driver", "java.lang.Object", null)), new org.jbpm.workflow.core.impl.DataDefinition("_95EFED1F-73F8-47E7-9604-A81EFE5DE8F5_driverInputX", "driver", "org.kie.kogito.traffic.Driver", null), null, null));
        ruleSetNode3.mapDataOutputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(new org.jbpm.workflow.core.impl.DataDefinition("_95EFED1F-73F8-47E7-9604-A81EFE5DE8F5_driverOutputX", "driver", "org.kie.kogito.traffic.Driver", null)), new org.jbpm.workflow.core.impl.DataDefinition("driver", "driver", "java.lang.Object", null), null, null));
        ruleSetNode3.metaData("UniqueId", "_95EFED1F-73F8-47E7-9604-A81EFE5DE8F5");
        ruleSetNode3.metaData("elementname", "LicenseValidation\nDRL");
        ruleSetNode3.metaData("x", 409);
        ruleSetNode3.metaData("width", 177);
        ruleSetNode3.metaData("y", 205);
        ruleSetNode3.metaData("height", 101);
        ruleSetNode3.done();
        org.jbpm.ruleflow.core.factory.WorkItemNodeFactory<?> workItemNode4 = factory.workItemNode(4);
        workItemNode4.name("Get Driver Details");
        workItemNode4.workName("org.kie.kogito.traffic.DriverService_getDriver_4_Handler");
        workItemNode4.workParameter("NodeName", "Get Driver Details");
        workItemNode4.workParameter("Interface", "org.kie.kogito.traffic.DriverService");
        workItemNode4.workParameter("Operation", "getDriver");
        workItemNode4.workParameter("interfaceImplementationRef", "org.kie.kogito.traffic.DriverService");
        workItemNode4.workParameter("operationImplementationRef", "getDriver");
        workItemNode4.workParameter("implementation", "Java");
        workItemNode4.mapDataInputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(new org.jbpm.workflow.core.impl.DataDefinition("driverId", "driverId", "java.lang.Object", null)), new org.jbpm.workflow.core.impl.DataDefinition("_93FFD317-476E-4624-84EF-994617572560_driverIdInputX", "driverId", "String", null), null, null));
        workItemNode4.mapDataOutputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(new org.jbpm.workflow.core.impl.DataDefinition("_93FFD317-476E-4624-84EF-994617572560_responseOutputX", "response", "org.kie.kogito.traffic.Driver", null)), new org.jbpm.workflow.core.impl.DataDefinition("driver", "driver", "java.lang.Object", null), null, null));
        workItemNode4.done();
        workItemNode4.metaData("UniqueId", "_93FFD317-476E-4624-84EF-994617572560");
        workItemNode4.metaData("Implementation", "Java");
        workItemNode4.metaData("elementname", "Get Driver Details");
        workItemNode4.metaData("Type", "Service Task");
        workItemNode4.metaData("OperationRef", "_93FFD317-476E-4624-84EF-994617572560_ServiceOperation");
        workItemNode4.metaData("x", 195);
        workItemNode4.metaData("width", 154);
        workItemNode4.metaData("y", 205);
        workItemNode4.metaData("height", 102);
        org.jbpm.ruleflow.core.factory.EndNodeFactory<?> endNode5 = factory.endNode(5);
        endNode5.name("End");
        endNode5.terminate(false);
        endNode5.metaData("UniqueId", "_67972C63-8A06-42C5-A3FF-A843EFB4D07B");
        endNode5.metaData("x", 1438);
        endNode5.metaData("width", 56);
        endNode5.metaData("y", 100);
        endNode5.metaData("height", 56);
        endNode5.done();
        org.jbpm.ruleflow.core.factory.ActionNodeFactory<?> actionNode6 = factory.actionNode(6);
        actionNode6.name("Suspended\nTask");
        actionNode6.action(kcontext -> {
            java.lang.String suspended = (java.lang.String) kcontext.getVariable("suspended");
            System.out.println("Driver is suspended!");
        });
        actionNode6.metaData("UniqueId", "_298312AB-7A3D-478B-BD9B-B260CE847645");
        actionNode6.metaData("elementname", "Suspended\nTask");
        actionNode6.metaData("NodeType", "ScriptTask");
        actionNode6.metaData("x", 1194);
        actionNode6.metaData("width", 178);
        actionNode6.metaData("y", 77);
        actionNode6.metaData("height", 102);
        actionNode6.done();
        org.jbpm.ruleflow.core.factory.SplitFactory<?> splitNode7 = factory.splitNode(7);
        splitNode7.name("Split");
        splitNode7.type(2);
        splitNode7.metaData("UniqueId", "_8A66FABC-E538-4F50-9DAC-BC9069D19942");
        splitNode7.metaData("x", 1078);
        splitNode7.metaData("width", 56);
        splitNode7.metaData("y", 225);
        splitNode7.metaData("Default", null);
        splitNode7.metaData("height", 56);
        splitNode7.constraint(9, "_19CC68B6-D2DC-4E39-99E5-CE5B30C5FEE6", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.String suspended = (java.lang.String) kcontext.getVariable("suspended");
            java.lang.String driverId = (java.lang.String) kcontext.getVariable("driverId");
            org.kie.kogito.traffic.Violation violation = (org.kie.kogito.traffic.Violation) kcontext.getVariable("violation");
            org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) kcontext.getVariable("driver");
            org.kie.kogito.traffic.Fine fine = (org.kie.kogito.traffic.Fine) kcontext.getVariable("fine");
            return "no".equalsIgnoreCase(suspended);
        }, 0, false);
        splitNode7.constraint(6, "_249EB7E9-5847-47C9-8B4D-8BEFED257600", "DROOLS_DEFAULT", "java", kcontext -> {
            java.lang.String suspended = (java.lang.String) kcontext.getVariable("suspended");
            java.lang.String driverId = (java.lang.String) kcontext.getVariable("driverId");
            org.kie.kogito.traffic.Violation violation = (org.kie.kogito.traffic.Violation) kcontext.getVariable("violation");
            org.kie.kogito.traffic.Driver driver = (org.kie.kogito.traffic.Driver) kcontext.getVariable("driver");
            org.kie.kogito.traffic.Fine fine = (org.kie.kogito.traffic.Fine) kcontext.getVariable("fine");
            return "yes".equalsIgnoreCase(suspended);
        }, 0, false);
        splitNode7.done();
        org.jbpm.ruleflow.core.factory.EndNodeFactory<?> endNode8 = factory.endNode(8);
        endNode8.name("End");
        endNode8.terminate(false);
        endNode8.metaData("UniqueId", "_418CD980-670D-4FC5-B492-A271A61B1477");
        endNode8.metaData("x", 1445);
        endNode8.metaData("width", 56);
        endNode8.metaData("y", 377);
        endNode8.metaData("height", 56);
        endNode8.done();
        org.jbpm.ruleflow.core.factory.ActionNodeFactory<?> actionNode9 = factory.actionNode(9);
        actionNode9.name("Not Suspended\n Task");
        actionNode9.action(kcontext -> {
            java.lang.String suspended = (java.lang.String) kcontext.getVariable("suspended");
            System.out.println("Driver is NOT suspended!");
        });
        actionNode9.metaData("UniqueId", "_DDD02AFB-D927-47BC-9C0C-523B602B5CD2");
        actionNode9.metaData("elementname", "Not Suspended\n Task");
        actionNode9.metaData("NodeType", "ScriptTask");
        actionNode9.metaData("x", 1203);
        actionNode9.metaData("width", 181);
        actionNode9.metaData("y", 355);
        actionNode9.metaData("height", 100);
        actionNode9.done();
        org.jbpm.ruleflow.core.factory.RuleSetNodeFactory<?> ruleSetNode10 = factory.ruleSetNode(10);
        ruleSetNode10.name("TrafficViolation\nDMN");
        ruleSetNode10.decision("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation", "Traffic Violation", () -> {
            return app.get(org.kie.kogito.decision.DecisionModels.class).getDecisionModel("https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", "Traffic Violation");
        });
        ruleSetNode10.mapDataInputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(), new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_namespaceInputX", "namespace", "java.lang.String", null), java.util.Arrays.asList(new org.jbpm.workflow.core.node.Assignment(null, new org.jbpm.workflow.core.impl.DataDefinition("8c1a0f8f-6287-4e94-b066-bd78971764c4", "EXPRESSION (https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF)", "java.lang.Object", "https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF"), new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_namespaceInputX", "namespace", "java.lang.String", null))), null));
        ruleSetNode10.mapDataInputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(), new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_decisionInputX", "decision", "java.lang.String", null), java.util.Arrays.asList(new org.jbpm.workflow.core.node.Assignment(null, new org.jbpm.workflow.core.impl.DataDefinition("01959a2e-3431-4b50-a274-02bef48ecf9d", "EXPRESSION (Traffic Violation)", "java.lang.Object", "Traffic Violation"), new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_decisionInputX", "decision", "java.lang.String", null))), null));
        ruleSetNode10.mapDataInputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(), new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_modelInputX", "model", "java.lang.String", null), java.util.Arrays.asList(new org.jbpm.workflow.core.node.Assignment(null, new org.jbpm.workflow.core.impl.DataDefinition("39f2b3c0-6ab9-4d43-bc8f-f7483c4278cd", "EXPRESSION (Traffic Violation)", "java.lang.Object", "Traffic Violation"), new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_modelInputX", "model", "java.lang.String", null))), null));
        ruleSetNode10.mapDataInputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(new org.jbpm.workflow.core.impl.DataDefinition("violation", "violation", "java.lang.Object", null)), new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_ViolationInputX", "Violation", "org.kie.kogito.traffic.Violation", null), null, null));
        ruleSetNode10.mapDataInputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(new org.jbpm.workflow.core.impl.DataDefinition("driver", "driver", "java.lang.Object", null)), new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_DriverInputX", "Driver", "org.kie.kogito.traffic.Driver", null), null, null));
        ruleSetNode10.mapDataOutputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_SuspendedOutputX", "Suspended", "String", null)), new org.jbpm.workflow.core.impl.DataDefinition("suspended", "suspended", "java.lang.Object", null), null, null));
        ruleSetNode10.mapDataOutputAssociation(new org.jbpm.workflow.core.impl.DataAssociation(java.util.Arrays.asList(new org.jbpm.workflow.core.impl.DataDefinition("_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941_FineOutputX", "Fine", "org.kie.kogito.traffic.Fine", null)), new org.jbpm.workflow.core.impl.DataDefinition("fine", "fine", "java.lang.Object", null), null, null));
        ruleSetNode10.metaData("UniqueId", "_B076DF7E-91A5-47C7-B3FC-2C2EC06E5941");
        ruleSetNode10.metaData("elementname", "TrafficViolation\nDMN");
        ruleSetNode10.metaData("x", 801);
        ruleSetNode10.metaData("width", 216);
        ruleSetNode10.metaData("y", 204);
        ruleSetNode10.metaData("height", 98);
        ruleSetNode10.done();
        org.jbpm.ruleflow.core.factory.StartNodeFactory<?> startNode11 = factory.startNode(11);
        startNode11.name("Start");
        startNode11.interrupting(true);
        startNode11.metaData("UniqueId", "_905F0834-19CC-423B-B90E-B38C6D80329F");
        startNode11.metaData("x", 79);
        startNode11.metaData("width", 56);
        startNode11.metaData("y", 227);
        startNode11.metaData("height", 56);
        startNode11.done();
        factory.connection(2, 1, "_044AA388-325A-45DE-B783-4F48421B788B");
        factory.connection(3, 2, "_D3E2F4B7-7739-452F-8D55-0C4F169D4A44");
        factory.connection(4, 3, "_A19108FE-08A2-4E80-B7A8-0254C49209A6");
        factory.connection(11, 4, "_2C2FFD79-4241-4F9E-A486-2482F817595E");
        factory.connection(6, 5, "_1287C97D-3568-458A-A907-0123A64A93BE");
        factory.connection(7, 6, "_249EB7E9-5847-47C9-8B4D-8BEFED257600");
        factory.connection(10, 7, "_B8BD225A-B26C-4C0F-9852-ED3664524A14");
        factory.connection(9, 8, "_521A00FC-6A79-44ED-8485-45DB97A621F2");
        factory.connection(7, 9, "_19CC68B6-D2DC-4E39-99E5-CE5B30C5FEE6");
        factory.connection(2, 10, "_8A36870E-651D-4E0A-B345-D5CFF2182F0F");
        factory.validate();
        return factory.getProcess();
    }
}
