/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.TimeUnit;
import org.acme.travel.Traveller;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
public class CloudEventListenerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudEventListenerTest.class);
    private static WireMockServer sink;

    @BeforeAll
    public static void startSink() {
        sink = new WireMockServer((Options)WireMockConfiguration.options().port(8181));
        sink.start();
        sink.stubFor(WireMock.post((String)"/").willReturn(WireMock.aResponse().withBody("ok").withStatus(200)));
    }

    @AfterAll
    public static void stopSink() {
        if (sink != null) {
            sink.stop();
        }
    }

    @Test
    void checkStartNewProcessInstanceWithCEForAmericans() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        Traveller traveller = new Traveller();
        traveller.setFirstName("Jane");
        traveller.setLastName("Doe");
        traveller.setEmail("jane.doe@example.com");
        traveller.setNationality("American");
        ((ValidatableResponse)((Response)RestAssured.given().header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)"000", new Object[0]).header("ce-source", (Object)"/from/test", new Object[0]).header("ce-type", (Object)"travellers", new Object[0]).contentType("application/json").body(objectMapper.writeValueAsString((Object)traveller)).post("/", new Object[0])).then()).statusCode(200);
    }

    @Test
    void checkStartNewProcessInstanceWithCE() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        Traveller traveller = new Traveller();
        traveller.setFirstName("Jane");
        traveller.setLastName("Doe");
        traveller.setEmail("jane.doe@example.com");
        traveller.setNationality("Polish");
        ((ValidatableResponse)((Response)RestAssured.given().header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)"000", new Object[0]).header("ce-source", (Object)"/from/test", new Object[0]).header("ce-type", (Object)"travellers", new Object[0]).contentType("application/json").body(objectMapper.writeValueAsString((Object)traveller)).post("/", new Object[0])).then()).statusCode(200);
        LOGGER.info("Waiting at most 2 seconds to receive the produced message");
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> sink.verify(1, WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")).withHeader("Content-Type", WireMock.containing((String)"application/cloudevents+json")).withRequestBody((ContentPattern)WireMock.containing((String)"jane.doe@example.com")).withRequestBody((ContentPattern)WireMock.containing((String)"\"source\":\"/process/Travelers\""))));
    }

    @Test
    void checkStartNewProcessInstanceWithSourceField() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        Traveller traveller = new Traveller();
        traveller.setFirstName("Jane");
        traveller.setLastName("Doe");
        traveller.setEmail("jane.doe2@example.com");
        traveller.setNationality("German");
        ((ValidatableResponse)((Response)RestAssured.given().header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)"000", new Object[0]).header("ce-source", (Object)"travellers", new Object[0]).header("ce-type", (Object)"whatevertype", new Object[0]).contentType("application/json").body(objectMapper.writeValueAsString((Object)traveller)).post("/", new Object[0])).then()).statusCode(200);
        LOGGER.info("Waiting at most 2 seconds to receive the produced message");
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> sink.verify(1, WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")).withHeader("Content-Type", WireMock.containing((String)"application/cloudevents+json")).withRequestBody((ContentPattern)WireMock.containing((String)"jane.doe2@example.com")).withRequestBody((ContentPattern)WireMock.containing((String)"\"source\":\"/process/Travelers\""))));
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }
}

