/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.examples.domain.FlightDTO;
import org.kie.kogito.examples.domain.Passenger;
import org.kie.kogito.examples.domain.PassengerDTO;

@QuarkusTest
public class FlightTest {
    @Test
    public void testFlightsProcess() throws JsonProcessingException {
        ObjectMapper jsonMapper = new ObjectMapper();
        FlightDTO flightParams = new FlightDTO();
        flightParams.setDepartureDateTime(LocalDateTime.now().toString());
        flightParams.setDestination("B");
        flightParams.setOrigin("A");
        flightParams.setSeatColumnSize(10);
        flightParams.setSeatRowSize(6);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("params", flightParams);
        String id = (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString(parameters)).contentType(ContentType.JSON).when().post("/rest/flights", new Object[0])).then()).statusCode(200)).body("params.departureDateTime", Matchers.is((Object)flightParams.getDepartureDateTime()), new Object[0])).body("params.origin", Matchers.is((Object)flightParams.getOrigin()), new Object[0])).body("params.destination", Matchers.is((Object)flightParams.getDestination()), new Object[0])).body("params.seatRowSize", Matchers.is((Object)flightParams.getSeatRowSize()), new Object[0])).body("params.seatColumnSize", Matchers.is((Object)flightParams.getSeatColumnSize()), new Object[0])).extract().body().path("id", new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)id), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id, new Object[0])).then()).statusCode(200)).body("params.departureDateTime", Matchers.is((Object)flightParams.getDepartureDateTime()), new Object[0])).body("params.origin", Matchers.is((Object)flightParams.getOrigin()), new Object[0])).body("params.destination", Matchers.is((Object)flightParams.getDestination()), new Object[0])).body("params.seatRowSize", Matchers.is((Object)flightParams.getSeatRowSize()), new Object[0])).body("params.seatColumnSize", Matchers.is((Object)flightParams.getSeatColumnSize()), new Object[0]);
        PassengerDTO passengerDTO = new PassengerDTO("john", "WINDOW", false, false, null);
        ((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString((Object)passengerDTO)).contentType(ContentType.JSON).when().post("/rest/flights/" + id + "/newPassengerRequest", new Object[0])).then()).statusCode(200);
        Map tasks = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id + "/tasks", new Object[0])).then()).extract().body().jsonPath().getMap("");
        Assertions.assertEquals((int)2, (int)tasks.size());
        MatcherAssert.assertThat(tasks.values(), (Matcher)Matchers.hasItem((Object)"approveDenyPassenger"));
        MatcherAssert.assertThat(tasks.values(), (Matcher)Matchers.hasItem((Object)"finalizePassengerList"));
        String approveDenyPassengerTask = tasks.entrySet().stream().filter(e -> ((String)e.getValue()).equals("approveDenyPassenger")).map(Map.Entry::getKey).findAny().get();
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id + "/approveDenyPassenger/" + approveDenyPassengerTask, new Object[0])).then()).statusCode(200)).body("passenger.name", Matchers.is((Object)passengerDTO.getName()), new Object[0]);
        parameters = new HashMap();
        parameters.put("isPassengerApproved", true);
        ((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString(parameters)).contentType(ContentType.JSON).when().post("/rest/flights/" + id + "/approveDenyPassenger/" + approveDenyPassengerTask, new Object[0])).then()).statusCode(200);
        String finalizePassengerListTask = tasks.entrySet().stream().filter(e -> ((String)e.getValue()).equals("finalizePassengerList")).map(Map.Entry::getKey).findAny().get();
        parameters = new HashMap();
        parameters.put("isPassengerListFinalized", true);
        ((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString(parameters)).contentType(ContentType.JSON).when().post("/rest/flights/" + id + "/finalizePassengerList/" + finalizePassengerListTask, new Object[0])).then()).statusCode(200);
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        tasks = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id + "/tasks", new Object[0])).then()).extract().body().jsonPath().getMap("");
        Assertions.assertEquals((int)1, (int)tasks.size());
        List passengerList = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id, new Object[0])).then()).statusCode(200)).extract().body().jsonPath().getList("flight.passengerList", Passenger.class);
        Assertions.assertNotNull((Object)((Passenger)passengerList.get(0)).getSeat());
        String finializeSeatAssignmentTask = (String)tasks.keySet().iterator().next();
        parameters = new HashMap();
        ((ValidatableResponse)((Response)RestAssured.given().body(jsonMapper.writeValueAsString(parameters)).contentType(ContentType.JSON).when().post("/rest/flights/" + id + "/finalizeSeatAssignment/" + finializeSeatAssignmentTask, new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights", new Object[0])).then()).statusCode(200)).body("", Matchers.hasSize((int)0), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/rest/flights/" + id, new Object[0])).then()).statusCode(204);
    }
}

