package org.kie.kogito.examples;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.Application;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.impl.Sig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.kie.kogito.examples.FlightsModelOutput;

@Path("/flights")
@org.springframework.stereotype.Component()
public class FlightsResource {

    @org.springframework.beans.factory.annotation.Autowired()
    @org.springframework.beans.factory.annotation.Qualifier("flights")
    Process<FlightsModel> process;

    @org.springframework.beans.factory.annotation.Autowired()
    Application application;

    @POST()
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public FlightsModelOutput createResource_flights(@Context HttpHeaders httpHeaders, @QueryParam("businessKey") String businessKey, @javax.validation.Valid() @javax.validation.constraints.NotNull() FlightsModelInput resource) {
        if (resource == null) {
            resource = new FlightsModelInput();
        }
        final FlightsModelInput value = resource;
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<FlightsModel> pi = process.createInstance(businessKey, mapInput(value, new FlightsModel()));
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            return getModel(pi);
        });
    }

    @GET()
    @Produces(MediaType.APPLICATION_JSON)
    public List<FlightsModelOutput> getResources_flights() {
        return process.instances().values().stream().map(pi -> mapOutput(new FlightsModelOutput(), pi.variables())).collect(Collectors.toList());
    }

    @GET()
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput getResource_flights(@PathParam("id") String id) {
        return process.instances().findById(id).map(pi -> mapOutput(new FlightsModelOutput(), pi.variables())).orElse(null);
    }

    @DELETE()
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput deleteResource_flights(@PathParam("id") final String id) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                pi.abort();
                return getModel(pi);
            }
        });
    }

    @POST()
    @Path("/{id}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput updateModel_flights(@PathParam("id") String id, FlightsModel resource) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                pi.updateVariables(resource);
                return mapOutput(new FlightsModelOutput(), pi.variables());
            }
        });
    }

    @GET()
    @Path("/{id}/tasks")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<String, String> getTasks_flights(@PathParam("id") String id, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        return process.instances().findById(id).map(pi -> pi.workItems(policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected FlightsModelOutput getModel(ProcessInstance<FlightsModel> pi) {
        if (pi.status() == ProcessInstance.STATE_ERROR && pi.error().isPresent()) {
            throw new ProcessInstanceExecutionException(pi.id(), pi.error().get().failedNodeId(), pi.error().get().errorMessage());
        }
        return mapOutput(new FlightsModelOutput(), pi.variables());
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        org.kie.kogito.auth.IdentityProvider identity = null;
        if (user != null) {
            identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
        }
        return new Policy[] { SecurityPolicy.of(identity) };
    }

    protected FlightsModel mapInput(@javax.validation.Valid() @javax.validation.constraints.NotNull() FlightsModelInput input, FlightsModel resource) {
        resource.fromMap(input.toMap());
        return resource;
    }

    protected FlightsModelOutput mapOutput(FlightsModelOutput output, FlightsModel resource) {
        output.fromMap(resource.getId(), resource.toMap());
        return output;
    }

    @POST
    @Path("/{id}/solvingTerminated")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_0(@PathParam("id") final String id, final org.kie.kogito.examples.domain.Flight data) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of("solvingTerminated", data));
            return getModel(pi);
        });
    }

    @POST
    @Path("/{id}/newPassengerRequest")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_1(@PathParam("id") final String id, final org.kie.kogito.examples.domain.PassengerDTO data) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of("newPassengerRequest", data));
            return getModel(pi);
        });
    }

    @POST
    @Path("/{id}/New_Best_Solution")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_2(@PathParam("id") final String id) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of("New Best Solution", null));
            return getModel(pi);
        });
    }

    @POST
    @Path("/{id}/newSolution")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_3(@PathParam("id") final String id, final org.kie.kogito.examples.domain.Flight data) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of("newSolution", data));
            return getModel(pi);
        });
    }

    @POST
    @Path("/{id}/Passenger_Boarding_Request")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public org.kie.kogito.examples.FlightsModelOutput signal_4(@PathParam("id") final String id) {
        return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of("Passenger Boarding Request", null));
            return getModel(pi);
        });
    }

    @POST()
    @Path("/{id}/finalizeSeatAssignment/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput completeTask_finalizeSeatAssignment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final Flights_6_TaskOutput model) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, model.toMap(), identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("/{id}/finalizeSeatAssignment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public Flights_6_TaskInput getTask_finalizeSeatAssignment_5(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return Flights_6_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE()
    @Path("/{id}/finalizeSeatAssignment/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput abortTask_finalizeSeatAssignment_5(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, null, identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @POST()
    @Path("/{id}/finalizePassengerList/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput completeTask_finalizePassengerList_6(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final Flights_7_TaskOutput model) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, model.toMap(), identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("/{id}/finalizePassengerList/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public Flights_7_TaskInput getTask_finalizePassengerList_6(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return Flights_7_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE()
    @Path("/{id}/finalizePassengerList/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput abortTask_finalizePassengerList_6(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, null, identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @POST()
    @Path("/{id}/approveDenyPassenger/{workItemId}")
    @Consumes(MediaType.APPLICATION_JSON)
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput completeTask_approveDenyPassenger_7(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("complete") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups, final Flights_18_TaskOutput model) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, model.toMap(), identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("/{id}/approveDenyPassenger/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public Flights_18_TaskInput getTask_approveDenyPassenger_7(@PathParam("id") String id, @PathParam("workItemId") String workItemId, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return Flights_18_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE()
    @Path("/{id}/approveDenyPassenger/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public FlightsModelOutput abortTask_approveDenyPassenger_7(@PathParam("id") final String id, @PathParam("workItemId") final String workItemId, @QueryParam("phase") @DefaultValue("abort") final String phase, @QueryParam("user") final String user, @QueryParam("group") final List<String> groups) {
        try {
            return org.kie.kogito.services.uow.UnitOfWorkExecutor.executeInUnitOfWork(application.unitOfWorkManager(), () -> {
                ProcessInstance<FlightsModel> pi = process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                org.kie.kogito.auth.IdentityProvider identity = null;
                if (user != null) {
                    identity = new org.kie.kogito.services.identity.StaticIdentityProvider(user, groups);
                }
                org.jbpm.process.instance.impl.humantask.HumanTaskTransition transition = new org.jbpm.process.instance.impl.humantask.HumanTaskTransition(phase, null, identity);
                pi.transitionWorkItem(workItemId, transition);
                return getModel(pi);
            });
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}
