/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.EventNodeFactory;
import org.jbpm.ruleflow.core.factory.EventSubProcessNodeFactory;
import org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.kogito.Model;
import org.kie.kogito.examples.Application;
import org.kie.kogito.examples.FlightsModel;
import org.kie.kogito.examples.FlightsProcessInstance;
import org.kie.kogito.examples.domain.PassengerDTO;
import org.kie.kogito.process.impl.AbstractProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="flights")
public class FlightsProcess
extends AbstractProcess<FlightsModel> {
    @Autowired(required=false)
    Collection<WorkItemHandler> handlers;
    Application app;

    public FlightsProcess() {
    }

    @Autowired
    public FlightsProcess(Application app) {
        super(app.config().process());
        this.app = app;
    }

    public FlightsProcessInstance createInstance(FlightsModel value) {
        return new FlightsProcessInstance(this, value, this.createProcessRuntime());
    }

    public FlightsProcessInstance createInstance(String businessKey, FlightsModel value) {
        return new FlightsProcessInstance(this, value, businessKey, this.createProcessRuntime());
    }

    public FlightsModel createModel() {
        return new FlightsModel();
    }

    public FlightsProcessInstance createInstance(Model value) {
        return this.createInstance((FlightsModel)value);
    }

    public FlightsProcessInstance createInstance(String businessKey, Model value) {
        return this.createInstance(businessKey, (FlightsModel)value);
    }

    public FlightsProcessInstance createInstance(WorkflowProcessInstance wpi) {
        return new FlightsProcessInstance(this, this.createModel(), this.createProcessRuntime(), wpi);
    }

    public FlightsProcess configure() {
        super.configure();
        this.handlers.forEach(h -> this.services.getWorkItemManager().registerWorkItemHandler(h.getName(), h));
        this.handlers.forEach(h -> this.services.getWorkItemManager().registerWorkItemHandler(h.getName(), h));
        this.handlers.forEach(h -> this.services.getWorkItemManager().registerWorkItemHandler(h.getName(), h));
        return this;
    }

    protected void registerListeners() {
    }

    public Process process() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"flights");
        factory.variable("flight", (DataType)new ObjectDataType("org.kie.kogito.examples.domain.Flight"), "customTags", null);
        factory.variable("params", (DataType)new ObjectDataType("org.kie.kogito.examples.domain.FlightDTO"), "customTags", null);
        factory.variable("isPassengerListFinalized", (DataType)new ObjectDataType("java.lang.Boolean"), "customTags", null);
        factory.variable("processId", (DataType)new ObjectDataType("java.lang.String"), "customTags", null);
        factory.variable("isSolving", (DataType)new ObjectDataType("java.lang.Boolean"), "customTags", null);
        factory.variable("isPassengerApproved", (DataType)new ObjectDataType("java.lang.Boolean"), "customTags", null);
        factory.variable("passengerRequest", (DataType)new ObjectDataType("org.kie.kogito.examples.domain.PassengerDTO"), "customTags", null);
        factory.name("Schedule Flight");
        factory.packageName("org.kie.kogito.examples");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        factory.metaData("TargetNamespace", (Object)"http://www.omg.org/bpmn20");
        ActionNodeFactory actionNode1 = factory.actionNode(1L);
        actionNode1.name("Update Is Solving");
        actionNode1.action(kcontext -> {
            Boolean isSolving = (Boolean)kcontext.getVariable("isSolving");
            kcontext.setVariable("isSolving", (Object)false);
        });
        actionNode1.metaData("UniqueId", (Object)"_60253406-278F-45E1-85BD-9FEBB74751E7");
        actionNode1.metaData("elementname", (Object)"Update Is Solving");
        actionNode1.metaData("NodeType", (Object)"ScriptTask");
        actionNode1.metaData("x", (Object)1036);
        actionNode1.metaData("width", (Object)154);
        actionNode1.metaData("y", (Object)678);
        actionNode1.metaData("height", (Object)102);
        actionNode1.done();
        EventNodeFactory eventNode2 = factory.eventNode(2L);
        eventNode2.name("Solver Terminated");
        eventNode2.eventType("solvingTerminated");
        eventNode2.variableName("flight");
        eventNode2.metaData("UniqueId", (Object)"_A6004C5E-5187-4DDE-A3C0-E7CA351B2E96");
        eventNode2.metaData("elementname", (Object)"Solver Terminated");
        eventNode2.metaData("EventType", (Object)"signal");
        eventNode2.metaData("x", (Object)916);
        eventNode2.metaData("width", (Object)56);
        eventNode2.metaData("y", (Object)701);
        eventNode2.metaData("height", (Object)56);
        eventNode2.done();
        ActionNodeFactory actionNode3 = factory.actionNode(3L);
        actionNode3.name("Init Variables");
        actionNode3.action(kcontext -> {
            Boolean isPassengerListFinalized = (Boolean)kcontext.getVariable("isPassengerListFinalized");
            String processId = (String)kcontext.getVariable("processId");
            Boolean isSolving = (Boolean)kcontext.getVariable("isSolving");
            kcontext.setVariable("isPassengerListFinalized", (Object)false);
            kcontext.setVariable("isSolving", (Object)true);
            kcontext.setVariable("processId", (Object)kcontext.getProcessInstance().getId());
        });
        actionNode3.metaData("UniqueId", (Object)"_900631B7-3F2A-4B12-859E-BC49336F1845");
        actionNode3.metaData("elementname", (Object)"Init Variables");
        actionNode3.metaData("NodeType", (Object)"ScriptTask");
        actionNode3.metaData("x", (Object)251);
        actionNode3.metaData("width", (Object)154);
        actionNode3.metaData("y", (Object)67);
        actionNode3.metaData("height", (Object)102);
        actionNode3.done();
        WorkItemNodeFactory workItemNode4 = factory.workItemNode(4L);
        workItemNode4.name("Create Seat Assignments");
        workItemNode4.workName("org.kie.kogito.examples.service.FlightSeatingSolveService_assignSeats_4_Handler");
        workItemNode4.workParameter("Interface", (Object)"org.kie.kogito.examples.service.FlightSeatingSolveService");
        workItemNode4.workParameter("Operation", (Object)"assignSeats");
        workItemNode4.workParameter("interfaceImplementationRef", (Object)"org.kie.kogito.examples.service.FlightSeatingSolveService");
        workItemNode4.workParameter("operationImplementationRef", (Object)"assignSeats");
        workItemNode4.workParameter("implementation", (Object)"Java");
        workItemNode4.inMapping("problem", "flight");
        workItemNode4.inMapping("problemId", "processId");
        workItemNode4.done();
        workItemNode4.metaData("UniqueId", (Object)"_33D305B7-7E3C-4704-860C-F3B6C4262B37");
        workItemNode4.metaData("Implementation", (Object)"Java");
        workItemNode4.metaData("elementname", (Object)"Create Seat Assignments");
        workItemNode4.metaData("Type", (Object)"Service Task");
        workItemNode4.metaData("OperationRef", (Object)"_33D305B7-7E3C-4704-860C-F3B6C4262B37_ServiceOperation");
        workItemNode4.metaData("x", (Object)697);
        workItemNode4.metaData("width", (Object)153);
        workItemNode4.metaData("y", (Object)678);
        workItemNode4.metaData("height", (Object)101);
        EndNodeFactory endNode5 = factory.endNode(5L);
        endNode5.name("End");
        endNode5.terminate(true);
        endNode5.metaData("UniqueId", (Object)"_C0E64248-F51D-4AA7-8E6F-22011EF77B8A");
        endNode5.metaData("x", (Object)1460);
        endNode5.metaData("width", (Object)56);
        endNode5.metaData("y", (Object)701);
        endNode5.metaData("height", (Object)56);
        endNode5.done();
        HumanTaskNodeFactory humanTaskNode6 = factory.humanTaskNode(6L);
        humanTaskNode6.name("Finalize Seat Assignments");
        humanTaskNode6.workParameter("TaskName", (Object)"finalizeSeatAssignment");
        humanTaskNode6.workParameter("Skippable", (Object)"false");
        humanTaskNode6.workParameter("NodeName", (Object)"Finalize Seat Assignments");
        humanTaskNode6.done();
        humanTaskNode6.metaData("UniqueId", (Object)"_F9063D79-F12D-4F18-9EE2-7034AE7C4776");
        humanTaskNode6.metaData("elementname", (Object)"Finalize Seat Assignments");
        humanTaskNode6.metaData("x", (Object)1248);
        humanTaskNode6.metaData("width", (Object)154);
        humanTaskNode6.metaData("y", (Object)678);
        humanTaskNode6.metaData("height", (Object)102);
        HumanTaskNodeFactory humanTaskNode7 = factory.humanTaskNode(7L);
        humanTaskNode7.name("Finalize Passenger List");
        humanTaskNode7.workParameter("TaskName", (Object)"finalizePassengerList");
        humanTaskNode7.workParameter("Skippable", (Object)"false");
        humanTaskNode7.workParameter("NodeName", (Object)"Finalize Passenger List");
        humanTaskNode7.outMapping("isPassengerListFinalized", "isPassengerListFinalized");
        humanTaskNode7.done();
        humanTaskNode7.metaData("UniqueId", (Object)"_5289B275-031F-437C-9538-CF0D3D4E83B9");
        humanTaskNode7.metaData("elementname", (Object)"Finalize Passenger List");
        humanTaskNode7.metaData("x", (Object)472);
        humanTaskNode7.metaData("width", (Object)154);
        humanTaskNode7.metaData("y", (Object)678);
        humanTaskNode7.metaData("height", (Object)102);
        WorkItemNodeFactory workItemNode8 = factory.workItemNode(8L);
        workItemNode8.name("Create a new flight");
        workItemNode8.workName("org.kie.kogito.examples.service.FlightService_createFlight_8_Handler");
        workItemNode8.workParameter("Interface", (Object)"org.kie.kogito.examples.service.FlightService");
        workItemNode8.workParameter("Operation", (Object)"createFlight");
        workItemNode8.workParameter("interfaceImplementationRef", (Object)"org.kie.kogito.examples.service.FlightService");
        workItemNode8.workParameter("operationImplementationRef", (Object)"createFlight");
        workItemNode8.workParameter("implementation", (Object)"Java");
        workItemNode8.inMapping("flightParams", "params");
        workItemNode8.outMapping("flight", "flight");
        workItemNode8.done();
        workItemNode8.metaData("UniqueId", (Object)"_3DA12126-C2FD-49CE-9119-615965FAC79D");
        workItemNode8.metaData("Implementation", (Object)"Java");
        workItemNode8.metaData("elementname", (Object)"Create a new flight");
        workItemNode8.metaData("Type", (Object)"Service Task");
        workItemNode8.metaData("OperationRef", (Object)"_3DA12126-C2FD-49CE-9119-615965FAC79D_ServiceOperation");
        workItemNode8.metaData("x", (Object)472);
        workItemNode8.metaData("width", (Object)154);
        workItemNode8.metaData("y", (Object)67);
        workItemNode8.metaData("height", (Object)102);
        StartNodeFactory startNode9 = factory.startNode(9L);
        startNode9.name("Process Start");
        startNode9.interrupting(false);
        startNode9.metaData("UniqueId", (Object)"_02BFCEB6-C148-4F2B-9CC9-E5BA5D7AFEDC");
        startNode9.metaData("elementname", (Object)"Process Start");
        startNode9.metaData("x", (Object)153);
        startNode9.metaData("width", (Object)56);
        startNode9.metaData("y", (Object)90);
        startNode9.metaData("height", (Object)56);
        startNode9.done();
        EventSubProcessNodeFactory eventSubProcessNode10 = factory.eventSubProcessNode(10L);
        eventSubProcessNode10.name("New Best Solution");
        eventSubProcessNode10.metaData("UniqueId", (Object)"_17238CD5-CB35-476E-A44C-B3A8E6F69096");
        eventSubProcessNode10.metaData("elementname", (Object)"New Best Solution");
        eventSubProcessNode10.metaData("x", (Object)820);
        eventSubProcessNode10.metaData("width", (Object)248);
        eventSubProcessNode10.metaData("y", (Object)821);
        eventSubProcessNode10.metaData("height", (Object)194);
        eventSubProcessNode10.keepActive(true);
        eventSubProcessNode10.event("newSolution");
        eventSubProcessNode10.autoComplete(true);
        EndNodeFactory endNode11 = eventSubProcessNode10.endNode(11L);
        endNode11.name("End");
        endNode11.terminate(false);
        endNode11.metaData("UniqueId", (Object)"_A30E28B4-D9E9-4FFD-B4F0-FD9B2A2785FD");
        endNode11.metaData("x", (Object)164);
        endNode11.metaData("width", (Object)56);
        endNode11.metaData("y", (Object)75);
        endNode11.metaData("height", (Object)56);
        endNode11.done();
        StartNodeFactory startNode12 = eventSubProcessNode10.startNode(12L);
        startNode12.name("New Best Solution");
        startNode12.interrupting(false);
        startNode12.metaData("TriggerMapping", (Object)"flight");
        startNode12.metaData("UniqueId", (Object)"_61AEF811-220F-4DB6-B0A1-818711C48323");
        startNode12.metaData("elementname", (Object)"New Best Solution");
        startNode12.metaData("TriggerType", (Object)"Signal");
        startNode12.metaData("x", (Object)38);
        startNode12.metaData("width", (Object)56);
        startNode12.metaData("y", (Object)75);
        startNode12.metaData("TriggerRef", (Object)"newSolution");
        startNode12.metaData("MessageType", (Object)"newSolution");
        startNode12.metaData("height", (Object)56);
        startNode12.done();
        startNode12.trigger("newSolution", "flight", "newSolution");
        eventSubProcessNode10.connection(12L, 11L, "_FC08A6A9-83FD-4950-B063-830CCB08F55B");
        eventSubProcessNode10.done();
        EventSubProcessNodeFactory eventSubProcessNode13 = factory.eventSubProcessNode(13L);
        eventSubProcessNode13.name("Passenger Boarding Request");
        eventSubProcessNode13.metaData("UniqueId", (Object)"_C9CB4707-AB7F-4B46-BFA2-4F8BF25AA037");
        eventSubProcessNode13.metaData("elementname", (Object)"Passenger Boarding Request");
        eventSubProcessNode13.metaData("x", (Object)618);
        eventSubProcessNode13.metaData("width", (Object)989);
        eventSubProcessNode13.metaData("y", (Object)203);
        eventSubProcessNode13.metaData("customAsync", (Object)"true");
        eventSubProcessNode13.metaData("height", (Object)401);
        eventSubProcessNode13.variable("isPassengerApproved", (DataType)new ObjectDataType("java.lang.Boolean"), "customTags", null);
        eventSubProcessNode13.variable("passengerRequest", (DataType)new ObjectDataType("org.kie.kogito.examples.domain.PassengerDTO"), "customTags", null);
        eventSubProcessNode13.keepActive(true);
        eventSubProcessNode13.event("newPassengerRequest");
        eventSubProcessNode13.autoComplete(true);
        WorkItemNodeFactory workItemNode16 = eventSubProcessNode13.workItemNode(16L);
        workItemNode16.name("Add Passenger To Flight");
        workItemNode16.workName("org.kie.kogito.examples.service.FlightService_addPassengerToFlight_16_Handler");
        workItemNode16.workParameter("Interface", (Object)"org.kie.kogito.examples.service.FlightService");
        workItemNode16.workParameter("Operation", (Object)"addPassengerToFlight");
        workItemNode16.workParameter("interfaceImplementationRef", (Object)"org.kie.kogito.examples.service.FlightService");
        workItemNode16.workParameter("operationImplementationRef", (Object)"addPassengerToFlight");
        workItemNode16.workParameter("implementation", (Object)"Java");
        workItemNode16.inMapping("flight", "flight");
        workItemNode16.inMapping("passenger", "passengerRequest");
        workItemNode16.outMapping("flight", "flight");
        workItemNode16.done();
        workItemNode16.metaData("UniqueId", (Object)"_5509C065-1D42-426E-8FF9-64D1E2E7B2EF");
        workItemNode16.metaData("Implementation", (Object)"Java");
        workItemNode16.metaData("elementname", (Object)"Add Passenger To Flight");
        workItemNode16.metaData("Type", (Object)"Service Task");
        workItemNode16.metaData("OperationRef", (Object)"_5509C065-1D42-426E-8FF9-64D1E2E7B2EF_ServiceOperation");
        workItemNode16.metaData("x", (Object)665);
        workItemNode16.metaData("width", (Object)154);
        workItemNode16.metaData("y", (Object)93);
        workItemNode16.metaData("height", (Object)102);
        SplitFactory splitNode17 = eventSubProcessNode13.splitNode(17L);
        splitNode17.name("Is Passenger Approved?");
        splitNode17.type(2);
        splitNode17.metaData("UniqueId", (Object)"_88B43256-BDA2-4AA8-B5A3-F43D9B799234");
        splitNode17.metaData("elementname", (Object)"Is Passenger Approved?");
        splitNode17.metaData("x", (Object)517);
        splitNode17.metaData("width", (Object)56);
        splitNode17.metaData("y", (Object)116);
        splitNode17.metaData("height", (Object)56);
        splitNode17.constraint(14L, "_94AD6769-D320-49C0-9CC1-92132A075462", "DROOLS_DEFAULT", "java", kcontext -> {
            Boolean isPassengerApproved = (Boolean)kcontext.getVariable("isPassengerApproved");
            PassengerDTO passengerRequest = (PassengerDTO)kcontext.getVariable("passengerRequest");
            return isPassengerApproved == false;
        }, 0);
        splitNode17.constraint(16L, "_C6BEB443-A465-4A89-B0CE-ACB76BEE7D03", "DROOLS_DEFAULT", "java", kcontext -> {
            Boolean isPassengerApproved = (Boolean)kcontext.getVariable("isPassengerApproved");
            PassengerDTO passengerRequest = (PassengerDTO)kcontext.getVariable("passengerRequest");
            return isPassengerApproved;
        }, 0);
        splitNode17.done();
        HumanTaskNodeFactory humanTaskNode18 = eventSubProcessNode13.humanTaskNode(18L);
        humanTaskNode18.name("Approve/Deny Passenger");
        humanTaskNode18.workParameter("TaskName", (Object)"approveDenyPassenger");
        humanTaskNode18.workParameter("Skippable", (Object)"false");
        humanTaskNode18.workParameter("NodeName", (Object)"Approve/Deny Passenger");
        humanTaskNode18.inMapping("passenger", "passengerRequest");
        humanTaskNode18.outMapping("isPassengerApproved", "isPassengerApproved");
        humanTaskNode18.done();
        humanTaskNode18.metaData("UniqueId", (Object)"_1120E34E-319E-49DF-AF68-7BB569F92ADC");
        humanTaskNode18.metaData("elementname", (Object)"Approve/Deny Passenger");
        humanTaskNode18.metaData("x", (Object)272);
        humanTaskNode18.metaData("width", (Object)154);
        humanTaskNode18.metaData("y", (Object)93);
        humanTaskNode18.metaData("height", (Object)102);
        StartNodeFactory startNode19 = eventSubProcessNode13.startNode(19L);
        startNode19.name("New Passenger Boarding Request");
        startNode19.interrupting(false);
        startNode19.metaData("TriggerMapping", (Object)"passengerRequest");
        startNode19.metaData("UniqueId", (Object)"_3F96473B-23BA-4A72-83D3-3EA4B33665D1");
        startNode19.metaData("elementname", (Object)"New Passenger Boarding Request");
        startNode19.metaData("TriggerType", (Object)"Signal");
        startNode19.metaData("x", (Object)98);
        startNode19.metaData("width", (Object)56);
        startNode19.metaData("y", (Object)117);
        startNode19.metaData("TriggerRef", (Object)"newPassengerRequest");
        startNode19.metaData("MessageType", (Object)"newPassengerRequest");
        startNode19.metaData("height", (Object)56);
        startNode19.done();
        startNode19.trigger("newPassengerRequest", "passengerRequest", "passenger");
        EndNodeFactory endNode14 = eventSubProcessNode13.endNode(14L);
        endNode14.name("End");
        endNode14.terminate(false);
        endNode14.metaData("UniqueId", (Object)"_1D32B117-1B5F-4F39-B2FC-9E682CA0B465");
        endNode14.metaData("x", (Object)517);
        endNode14.metaData("width", (Object)56);
        endNode14.metaData("y", (Object)300);
        endNode14.metaData("height", (Object)56);
        endNode14.done();
        EndNodeFactory endNode15 = eventSubProcessNode13.endNode(15L);
        endNode15.name("End");
        endNode15.terminate(false);
        endNode15.metaData("UniqueId", (Object)"_1CBDC9E4-A8ED-4927-A7A9-2199194E569B");
        endNode15.metaData("x", (Object)911);
        endNode15.metaData("width", (Object)56);
        endNode15.metaData("y", (Object)116);
        endNode15.metaData("height", (Object)56);
        endNode15.done();
        eventSubProcessNode13.connection(17L, 16L, "_C6BEB443-A465-4A89-B0CE-ACB76BEE7D03");
        eventSubProcessNode13.connection(18L, 17L, "_3FD370AA-36A7-4074-8977-5F58E0E88F04");
        eventSubProcessNode13.connection(19L, 18L, "_8AE45BEB-7A37-4A21-B22A-3DA124D3368E");
        eventSubProcessNode13.connection(17L, 14L, "_94AD6769-D320-49C0-9CC1-92132A075462");
        eventSubProcessNode13.connection(16L, 15L, "_A95FF555-9C22-42E4-A25F-7D4724BD2AEF");
        eventSubProcessNode13.done();
        factory.connection(2L, 1L, "_84ABBA79-4757-4215-8959-2747FAC73471");
        factory.connection(4L, 2L, "_A59B010C-5D2C-45DF-9219-A46D06EEE82D");
        factory.connection(9L, 3L, "_F33764FA-886E-4033-AD8B-7D7F0FC5EA5D");
        factory.connection(7L, 4L, "_EF6673DD-1D02-4E37-833A-810CB29DC113");
        factory.connection(6L, 5L, "_29D92CB9-DE14-4571-9399-FD1BAD9595D6");
        factory.connection(1L, 6L, "_7FCA2AF9-B5EB-4C08-ABF5-E10D9917E88E");
        factory.connection(8L, 7L, "_1C8C09DA-FFCF-4ACA-A3FD-D63E14B32C41");
        factory.connection(3L, 8L, "_4F515548-C937-4BA7-84D5-21776CFD70D5");
        factory.validate();
        return factory.getProcess();
    }

    @PostConstruct
    public void init() {
        this.activate();
    }
}

