/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.service;

import java.util.concurrent.ExecutionException;
import org.kie.kogito.examples.domain.Flight;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.impl.Sig;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class FlightSeatingSolveService {
    @Autowired
    private SolverManager<Flight, String> solverManager;
    @Autowired
    @Qualifier(value="flights")
    private Process<?> process;
    @Autowired
    private AsyncTaskExecutor taskExecutor;

    public void assignSeats(String id, Flight problem) {
        SolverJob solverJob = this.solverManager.solveAndListen((Object)id, problemId -> problem, bestSolution -> this.process.instances().findById(id).ifPresent(pi -> pi.send(Sig.of((String)"newSolution", (Object)bestSolution))));
        this.taskExecutor.execute(() -> {
            try {
                Flight finalBestSolution = (Flight)solverJob.getFinalBestSolution();
                this.process.instances().findById(id).ifPresent(pi -> pi.send(Sig.of((String)"solvingTerminated", (Object)finalBestSolution)));
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }
}

