package org.kie.kogito.examples;

import java.util.Map;
import org.kie.kogito.UserTask;
import org.kie.kogito.UserTaskParam.ParamType;
import org.kie.kogito.UserTaskParam;

@UserTask(taskName = "approveDenyPassenger", processName = "flights")
public class Flights_18_TaskInput {

    private String _id;

    private String _name;

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public static Flights_18_TaskInput from(org.kie.kogito.process.WorkItem workItem) {
        Flights_18_TaskInput item = new Flights_18_TaskInput();
        item._id = workItem.getId();
        item._name = workItem.getName();
        Map<String, Object> params = workItem.getParameters();
        item.passenger = (org.kie.kogito.examples.domain.PassengerDTO) params.get("passenger");
        return item;
    }

    @UserTaskParam(value = ParamType.INPUT)
    private org.kie.kogito.examples.domain.PassengerDTO passenger;

    public org.kie.kogito.examples.domain.PassengerDTO getPassenger() {
        return passenger;
    }

    public void setPassenger(org.kie.kogito.examples.domain.PassengerDTO passenger) {
        this.passenger = passenger;
    }
}
// Task input model for user task 'Approve/Deny Passenger' in process 'flights'
