/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.examples.FlightsModel;
import org.kie.kogito.examples.FlightsModelInput;
import org.kie.kogito.examples.FlightsModelOutput;
import org.kie.kogito.examples.Flights_18_TaskInput;
import org.kie.kogito.examples.Flights_18_TaskOutput;
import org.kie.kogito.examples.Flights_6_TaskInput;
import org.kie.kogito.examples.Flights_6_TaskOutput;
import org.kie.kogito.examples.Flights_7_TaskInput;
import org.kie.kogito.examples.Flights_7_TaskOutput;
import org.kie.kogito.examples.domain.Flight;
import org.kie.kogito.examples.domain.PassengerDTO;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/flights"})
@Component
public class FlightsResource {
    @Autowired
    @Qualifier(value="flights")
    Process<FlightsModel> process;
    @Autowired
    Application application;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> createResource_flights(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull FlightsModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            FlightsModelInput inputModel = resource != null ? resource : new FlightsModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            List startFromNode = httpHeaders.get((Object)"X-KOGITO-StartFromNode");
            if (startFromNode != null && !startFromNode.isEmpty()) {
                pi.startFrom((String)startFromNode.get(0));
            } else {
                pi.start();
            }
            UriComponents uriComponents = uriComponentsBuilder.path("/flights/{id}").buildAndExpand(new Object[]{pi.id()});
            URI location = uriComponents.toUri();
            return ResponseEntity.created((URI)location).body((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        });
    }

    @GetMapping(produces={"application/json"})
    public List<FlightsModelOutput> getResources_flights() {
        return this.process.instances().values().stream().map(pi -> ((FlightsModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> getResource_flights(@PathVariable(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(m -> ResponseEntity.ok((Object)((FlightsModel)m.variables()).toOutput())).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> deleteResource_flights(@PathVariable(value="id") String id) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((FlightsModel)pi.checkError().variables()).toOutput();
        }).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> updateModel_flights(@PathVariable(value="id") String id, @RequestBody(required=false) FlightsModel resource) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((FlightsModel)pi.updateVariables((Object)resource)).toOutput()).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    public ResponseEntity<List<WorkItem>> getTasks_flights(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of((String)user, (Collection)groups))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/{id}/solvingTerminated"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_0(@PathVariable(value="id") String id, @RequestBody(required=false) Flight data) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"solvingTerminated", (Object)data));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/newPassengerRequest"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_1(@PathVariable(value="id") String id, @RequestBody(required=false) PassengerDTO data) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"newPassengerRequest", (Object)data));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/New_Best_Solution"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_2(@PathVariable(value="id") String id) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"New Best Solution", null));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/newSolution"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_3(@PathVariable(value="id") String id, @RequestBody(required=false) Flight data) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"newSolution", (Object)data));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/Passenger_Boarding_Request"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> signal_4(@PathVariable(value="id") String id) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.send(Sig.of((String)"Passenger Boarding Request", null));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizeSeatAssignment/{workItemId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> completeTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups, @RequestBody(required=false) Flights_6_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<Flights_6_TaskInput> getTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Flights_6_TaskInput.from((WorkItem)pi.workItem(workItemId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"finalizeSeatAssignment/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_finalizeSeatAssignment_5() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizeSeatAssignment");
    }

    @GetMapping(value={"/{id}/finalizeSeatAssignment/{workItemId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizeSeatAssignment"));
    }

    @DeleteMapping(value={"/{id}/finalizeSeatAssignment/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> abortTask_finalizeSeatAssignment_5(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/finalizePassengerList/{workItemId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> completeTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups, @RequestBody(required=false) Flights_7_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<Flights_7_TaskInput> getTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Flights_7_TaskInput.from((WorkItem)pi.workItem(workItemId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"finalizePassengerList/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_finalizePassengerList_6() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizePassengerList");
    }

    @GetMapping(value={"/{id}/finalizePassengerList/{workItemId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"finalizePassengerList"));
    }

    @DeleteMapping(value={"/{id}/finalizePassengerList/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> abortTask_finalizePassengerList_6(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/approveDenyPassenger/{workItemId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<FlightsModelOutput> completeTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups, @RequestBody(required=false) Flights_18_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<Flights_18_TaskInput> getTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Flights_18_TaskInput.from((WorkItem)pi.workItem(workItemId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"approveDenyPassenger/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_approveDenyPassenger_7() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"approveDenyPassenger");
    }

    @GetMapping(value={"/{id}/approveDenyPassenger/{workItemId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"approveDenyPassenger"));
    }

    @DeleteMapping(value={"/{id}/approveDenyPassenger/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<FlightsModelOutput> abortTask_approveDenyPassenger_7(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((FlightsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }
}

